/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.analysis.directed;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.picard.analysis.InsertSizeMetrics;
import net.sf.picard.analysis.MetricAccumulationLevel;
import net.sf.picard.analysis.directed.InsertSizeCollectorArgs;
import net.sf.picard.metrics.MetricsFile;
import net.sf.picard.metrics.MultiLevelCollector;
import net.sf.picard.metrics.PerUnitMetricCollector;
import net.sf.picard.reference.ReferenceSequence;
import net.sf.picard.util.Histogram;
import net.sf.samtools.SAMReadGroupRecord;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SamPairUtil;

public class InsertSizeMetricsCollector
extends MultiLevelCollector<InsertSizeMetrics, Integer, InsertSizeCollectorArgs> {
    private final double minimumPct;
    private final double deviations;
    private Integer histogramWidth;

    public InsertSizeMetricsCollector(Set<MetricAccumulationLevel> accumulationLevels, List<SAMReadGroupRecord> samRgRecords, double minimumPct, Integer histogramWidth, double deviations) {
        this.minimumPct = minimumPct;
        this.histogramWidth = histogramWidth;
        this.deviations = deviations;
        this.setup(accumulationLevels, samRgRecords);
    }

    @Override
    protected InsertSizeCollectorArgs makeArg(SAMRecord samRecord, ReferenceSequence refSeq) {
        int insertSize = Math.abs(samRecord.getInferredInsertSize());
        SamPairUtil.PairOrientation orientation = SamPairUtil.getPairOrientation(samRecord);
        return new InsertSizeCollectorArgs(insertSize, orientation);
    }

    @Override
    protected PerUnitMetricCollector<InsertSizeMetrics, Integer, InsertSizeCollectorArgs> makeChildCollector(String sample, String library, String readGroup) {
        return new PerUnitInsertSizeMetricsCollector(sample, library, readGroup);
    }

    @Override
    public void acceptRecord(SAMRecord record, ReferenceSequence refSeq) {
        if (!record.getReadPairedFlag() || record.getReadUnmappedFlag() || record.getMateUnmappedFlag() || record.getFirstOfPairFlag() || record.isSecondaryOrSupplementary() || record.getDuplicateReadFlag() || record.getInferredInsertSize() == 0) {
            return;
        }
        super.acceptRecord(record, refSeq);
    }

    public class PerUnitInsertSizeMetricsCollector
    implements PerUnitMetricCollector<InsertSizeMetrics, Integer, InsertSizeCollectorArgs> {
        final EnumMap<SamPairUtil.PairOrientation, Histogram<Integer>> histograms = new EnumMap(SamPairUtil.PairOrientation.class);
        final String sample;
        final String library;
        final String readGroup;
        private double totalInserts = 0.0;

        public PerUnitInsertSizeMetricsCollector(String sample, String library, String readGroup) {
            this.sample = sample;
            this.library = library;
            this.readGroup = readGroup;
            String prefix = null;
            prefix = this.readGroup != null ? this.readGroup + "." : (this.library != null ? this.library + "." : (this.sample != null ? this.sample + "." : "All_Reads."));
            this.histograms.put(SamPairUtil.PairOrientation.FR, new Histogram("insert_size", prefix + "fr_count"));
            this.histograms.put(SamPairUtil.PairOrientation.TANDEM, new Histogram("insert_size", prefix + "tandem_count"));
            this.histograms.put(SamPairUtil.PairOrientation.RF, new Histogram("insert_size", prefix + "rf_count"));
        }

        @Override
        public void acceptRecord(InsertSizeCollectorArgs args) {
            this.histograms.get((Object)args.getPairOrientation()).increment(args.getInsertSize());
        }

        @Override
        public void finish() {
        }

        public double getTotalInserts() {
            return this.totalInserts;
        }

        @Override
        public void addMetricsToFile(MetricsFile<InsertSizeMetrics, Integer> file) {
            for (Histogram<Integer> histogram : this.histograms.values()) {
                this.totalInserts += histogram.getCount();
            }
            for (Map.Entry entry : this.histograms.entrySet()) {
                SamPairUtil.PairOrientation pairOrientation = (SamPairUtil.PairOrientation)((Object)entry.getKey());
                Histogram histogram = (Histogram)entry.getValue();
                double total = histogram.getCount();
                if (!(total > this.totalInserts * InsertSizeMetricsCollector.this.minimumPct)) continue;
                InsertSizeMetrics metrics = new InsertSizeMetrics();
                metrics.SAMPLE = this.sample;
                metrics.LIBRARY = this.library;
                metrics.READ_GROUP = this.readGroup;
                metrics.PAIR_ORIENTATION = pairOrientation;
                metrics.READ_PAIRS = (long)total;
                metrics.MAX_INSERT_SIZE = (int)histogram.getMax();
                metrics.MIN_INSERT_SIZE = (int)histogram.getMin();
                metrics.MEDIAN_INSERT_SIZE = histogram.getMedian();
                metrics.MEDIAN_ABSOLUTE_DEVIATION = histogram.getMedianAbsoluteDeviation();
                double median = histogram.getMedian();
                double covered = 0.0;
                double low = median;
                for (double high = median; low >= histogram.getMin() || high <= histogram.getMax(); low -= 1.0, high += 1.0) {
                    Histogram.Bin highBin;
                    Histogram.Bin lowBin = (Histogram.Bin)histogram.get((int)low);
                    if (lowBin != null) {
                        covered += lowBin.getValue();
                    }
                    if (low != high && (highBin = (Histogram.Bin)histogram.get((int)high)) != null) {
                        covered += highBin.getValue();
                    }
                    double percentCovered = covered / total;
                    int distance = (int)(high - low) + 1;
                    if (percentCovered >= 0.1 && metrics.WIDTH_OF_10_PERCENT == 0) {
                        metrics.WIDTH_OF_10_PERCENT = distance;
                    }
                    if (percentCovered >= 0.2 && metrics.WIDTH_OF_20_PERCENT == 0) {
                        metrics.WIDTH_OF_20_PERCENT = distance;
                    }
                    if (percentCovered >= 0.3 && metrics.WIDTH_OF_30_PERCENT == 0) {
                        metrics.WIDTH_OF_30_PERCENT = distance;
                    }
                    if (percentCovered >= 0.4 && metrics.WIDTH_OF_40_PERCENT == 0) {
                        metrics.WIDTH_OF_40_PERCENT = distance;
                    }
                    if (percentCovered >= 0.5 && metrics.WIDTH_OF_50_PERCENT == 0) {
                        metrics.WIDTH_OF_50_PERCENT = distance;
                    }
                    if (percentCovered >= 0.6 && metrics.WIDTH_OF_60_PERCENT == 0) {
                        metrics.WIDTH_OF_60_PERCENT = distance;
                    }
                    if (percentCovered >= 0.7 && metrics.WIDTH_OF_70_PERCENT == 0) {
                        metrics.WIDTH_OF_70_PERCENT = distance;
                    }
                    if (percentCovered >= 0.8 && metrics.WIDTH_OF_80_PERCENT == 0) {
                        metrics.WIDTH_OF_80_PERCENT = distance;
                    }
                    if (percentCovered >= 0.9 && metrics.WIDTH_OF_90_PERCENT == 0) {
                        metrics.WIDTH_OF_90_PERCENT = distance;
                    }
                    if (!(percentCovered >= 0.99) || metrics.WIDTH_OF_99_PERCENT != 0) continue;
                    metrics.WIDTH_OF_99_PERCENT = distance;
                }
                Histogram trimmedHisto = histogram;
                if (InsertSizeMetricsCollector.this.histogramWidth == null) {
                    InsertSizeMetricsCollector.this.histogramWidth = (int)(metrics.MEDIAN_INSERT_SIZE + InsertSizeMetricsCollector.this.deviations * metrics.MEDIAN_ABSOLUTE_DEVIATION);
                }
                trimmedHisto.trimByWidth(InsertSizeMetricsCollector.this.histogramWidth);
                metrics.MEAN_INSERT_SIZE = trimmedHisto.getMean();
                metrics.STANDARD_DEVIATION = trimmedHisto.getStandardDeviation();
                file.addHistogram(trimmedHisto);
                file.addMetric(metrics);
            }
        }
    }
}

