/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import net.sf.picard.PicardException;
import net.sf.picard.illumina.parser.CycleFilesIterator;

class CycleIlluminaFileMap
extends TreeMap<Integer, CycleFilesIterator> {
    CycleIlluminaFileMap() {
    }

    public CycleIlluminaFileMap keep(List<Integer> tilesToKeep, int[] cycles) {
        if (tilesToKeep == null) {
            tilesToKeep = new ArrayList(this.keySet());
        }
        CycleIlluminaFileMap ciMap = new CycleIlluminaFileMap();
        for (Integer tile : tilesToKeep) {
            CycleFilesIterator template = (CycleFilesIterator)this.get(tile);
            if (template == null) continue;
            ciMap.put(tile, new CycleFilesIterator((CycleFilesIterator)this.get(tile), cycles));
        }
        return ciMap;
    }

    public void assertValid(List<Integer> expectedTiles, int[] expectedCycles) {
        if (this.size() != expectedTiles.size()) {
            throw new PicardException("Expected CycledIlluminaFileMap to contain " + expectedTiles + " tiles but only " + this.size() + " were found!");
        }
        Object curFile = null;
        for (int tile : expectedTiles) {
            ((CycleFilesIterator)this.get(tile)).assertValid(expectedCycles);
        }
    }

    public static File incrementCycleCount(File cycleFile) {
        File cycleDir = cycleFile.getParentFile();
        int cycle = Integer.parseInt(cycleDir.getName().substring(1, cycleDir.getName().lastIndexOf(".")));
        return new File(cycleDir.getParentFile(), "C" + cycle + ".1" + File.separator + cycleFile.getName());
    }

    public static String remainingCyclesToString(CycleFilesIterator cfi) {
        String cycles = "";
        if (cfi.hasNext()) {
            cycles = cycles + cfi.getNextCycle();
            cfi.next();
        }
        while (cfi.hasNext()) {
            cycles = cycles + ", " + cfi.getNextCycle();
            cfi.next();
        }
        return cycles;
    }
}

