/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser;

public enum IlluminaMetricsCode {
    DENSITY_ID(100),
    CLUSTER_ID(102),
    PHASING_BASE(200),
    PREPHASING_BASE(201);

    private final int metricsCode;

    private IlluminaMetricsCode(int metricsCode) {
        this.metricsCode = metricsCode;
    }

    public static int getPhasingCode(int readDescriptorIndex, IlluminaMetricsCode phasingType) {
        if (!IlluminaMetricsCode.isPhasing(phasingType)) {
            throw new IllegalArgumentException("phasingType must be PHASING_BASE or PREPHASING_BASE");
        }
        return phasingType.getMetricsCode() + readDescriptorIndex * 2;
    }

    public static boolean isPhasing(IlluminaMetricsCode metricsCode) {
        return metricsCode.equals((Object)PHASING_BASE) || metricsCode.equals((Object)PREPHASING_BASE);
    }

    public int getMetricsCode() {
        return this.metricsCode;
    }
}

