/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser;

import java.io.File;
import java.util.Collections;
import java.util.List;
import net.sf.picard.illumina.parser.IlluminaDataType;
import net.sf.picard.illumina.parser.MultiTileParser;
import net.sf.picard.illumina.parser.PositionalData;
import net.sf.picard.illumina.parser.TileIndex;
import net.sf.picard.illumina.parser.readers.AbstractIlluminaPositionFileReader;
import net.sf.picard.illumina.parser.readers.LocsFileReader;

public class MultiTileLocsParser
extends MultiTileParser<PositionalData> {
    private final LocsFileReader reader;
    private final int lane;

    public MultiTileLocsParser(TileIndex tileIndex, List<Integer> requestedTiles, File locsFile, int lane) {
        super(tileIndex, requestedTiles, Collections.singleton(IlluminaDataType.Position));
        int tileNumber = requestedTiles.size() == 1 ? requestedTiles.get(0) : -1;
        this.reader = new LocsFileReader(locsFile, lane, tileNumber);
        this.lane = lane;
    }

    @Override
    PositionalData readNext() {
        final int tile = this.getTileOfNextCluster();
        final AbstractIlluminaPositionFileReader.PositionInfo nextVal = this.reader.next();
        return new PositionalData(){

            @Override
            public int getXCoordinate() {
                return nextVal.xQseqCoord;
            }

            @Override
            public int getYCoordinate() {
                return nextVal.yQseqCoord;
            }

            public int getLane() {
                return MultiTileLocsParser.this.lane;
            }

            public int getTile() {
                return tile;
            }
        };
    }

    @Override
    void skipRecords(int numToSkip) {
        this.reader.skipRecords(numToSkip);
    }
}

