/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import net.sf.picard.illumina.parser.TilePhasingValue;
import net.sf.picard.illumina.parser.TileTemplateRead;
import net.sf.samtools.util.CollectionUtil;

public class Tile {
    private final int lane;
    private final int tile;
    private final float density;
    private final float clusters;
    private final Map<TileTemplateRead, Float> phasingMap;
    private final Map<TileTemplateRead, Float> prePhasingMap;

    public Tile(int lane, int tile, float density, float clusters, TilePhasingValue ... tilePhasingValues) {
        this.lane = lane;
        this.tile = tile;
        this.density = density;
        this.clusters = clusters;
        Collection<TilePhasingValue> phasingValues = Tile.ensureSoleTilePhasingValuesPerRead(Arrays.asList(tilePhasingValues));
        HashMap<TileTemplateRead, Float> phasingMap = new HashMap<TileTemplateRead, Float>();
        HashMap<TileTemplateRead, Float> prePhasingMap = new HashMap<TileTemplateRead, Float>();
        for (TilePhasingValue phasingValue : phasingValues) {
            phasingMap.put(phasingValue.getTileTemplateRead(), Float.valueOf(phasingValue.getPhasingValue()));
            prePhasingMap.put(phasingValue.getTileTemplateRead(), Float.valueOf(phasingValue.getPrePhasingValue()));
        }
        this.phasingMap = Collections.unmodifiableMap(phasingMap);
        this.prePhasingMap = Collections.unmodifiableMap(prePhasingMap);
    }

    public int getLaneNumber() {
        return this.lane;
    }

    public int getTileNumber() {
        return this.tile;
    }

    public float getClusterDensity() {
        return this.density;
    }

    public float getClusterCount() {
        return this.clusters;
    }

    public Map<TileTemplateRead, Float> getPhasingMap() {
        return this.phasingMap;
    }

    public Map<TileTemplateRead, Float> getPrePhasingMap() {
        return this.prePhasingMap;
    }

    private static Collection<TilePhasingValue> ensureSoleTilePhasingValuesPerRead(Collection<TilePhasingValue> tilePhasingValues) {
        Map<TileTemplateRead, Collection<TilePhasingValue>> partitionedMap = CollectionUtil.partition(tilePhasingValues, new CollectionUtil.Partitioner<TilePhasingValue, TileTemplateRead>(){

            @Override
            public TileTemplateRead getPartition(TilePhasingValue phasingValue) {
                return phasingValue.getTileTemplateRead();
            }
        });
        LinkedList<TilePhasingValue> newTilePhasingValues = new LinkedList<TilePhasingValue>();
        for (TileTemplateRead read : partitionedMap.keySet()) {
            newTilePhasingValues.add(CollectionUtil.getSoleElement(partitionedMap.get((Object)read)));
        }
        return newTilePhasingValues;
    }
}

