/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser.fakers;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.List;
import net.sf.picard.illumina.parser.fakers.FileFaker;
import net.sf.samtools.util.CloserUtil;

public class BciFileFaker
extends FileFaker {
    @Override
    protected void fakeFile(ByteBuffer buffer) {
        for (Integer tile : this.tiles) {
            buffer.putInt(tile);
            buffer.putInt(1);
        }
    }

    @Override
    protected boolean addLeadingZeros() {
        return false;
    }

    @Override
    protected int bufferSize() {
        return 8 * this.tiles.size();
    }

    public void fakeBciFile(File bci, List<Integer> expectedTiles) throws IOException {
        this.tiles = expectedTiles;
        FileOutputStream fileOutputStream = new FileOutputStream(bci);
        FileChannel channel = fileOutputStream.getChannel();
        ByteBuffer buffer = ByteBuffer.allocate(8 * expectedTiles.size());
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        this.fakeFile(buffer);
        buffer.flip();
        channel.write(buffer);
        channel.force(true);
        CloserUtil.close(channel);
        CloserUtil.close(fileOutputStream);
    }
}

