/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser.fakers;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.Collections;
import java.util.List;
import net.sf.samtools.util.CloserUtil;

public abstract class FileFaker {
    int size;
    List<Integer> tiles;

    protected abstract void fakeFile(ByteBuffer var1);

    protected abstract boolean addLeadingZeros();

    protected abstract int bufferSize();

    public void fakeFile(File base, int tile, int lane, String extension) throws IOException {
        this.fakeFile(base, Collections.singletonList(tile), lane, extension);
    }

    public void fakeFile(File base, List<Integer> expectedTiles, int lane, String extension) throws IOException {
        if (base.exists() || base.mkdirs()) {
            File fakeFile;
            this.tiles = expectedTiles;
            if (expectedTiles.size() == 1) {
                String longTileName = String.valueOf(this.tiles.get(0));
                if (this.addLeadingZeros()) {
                    while (longTileName.length() < 4) {
                        longTileName = "0" + longTileName;
                    }
                }
                fakeFile = new File(base, String.format("s_%d_%s%s", lane, longTileName, extension));
            } else {
                fakeFile = new File(base, String.format("s_%s%s", lane, extension));
            }
            this.fakeFile(fakeFile, this.bufferSize());
        }
    }

    public void fakeFile(File cycleFile, Integer size) throws IOException {
        if (size == null) {
            size = 1;
        }
        this.size = size;
        FileOutputStream fileOutputStream = new FileOutputStream(cycleFile);
        FileChannel channel = fileOutputStream.getChannel();
        ByteBuffer buffer = ByteBuffer.allocate(size);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        this.fakeFile(buffer);
        buffer.flip();
        channel.write(buffer);
        CloserUtil.close(channel);
        CloserUtil.close(fileOutputStream);
    }
}

