/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser.readers;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.sf.picard.PicardException;
import net.sf.samtools.util.CollectionUtil;

public class BclQualityEvaluationStrategy {
    public static final int ILLUMINA_ALLEGED_MINIMUM_QUALITY = 2;
    private final int minimumRevisedQuality;
    private Map<Byte, AtomicInteger> qualityCountMap = Collections.synchronizedMap(new CollectionUtil.DefaultingMap<Byte, AtomicInteger>(new CollectionUtil.DefaultingMap.Factory<AtomicInteger, Byte>(){

        @Override
        public AtomicInteger make(Byte b) {
            return new AtomicInteger(0);
        }
    }, true));

    public BclQualityEvaluationStrategy(int minimumRevisedQuality) {
        this.minimumRevisedQuality = minimumRevisedQuality;
    }

    private static byte generateRevisedQuality(byte quality) {
        return (byte)Math.max(quality, 1);
    }

    public byte reviseAndConditionallyLogQuality(byte quality) {
        byte revisedQuality = BclQualityEvaluationStrategy.generateRevisedQuality(quality);
        if (quality < 2) {
            this.qualityCountMap.get(quality).incrementAndGet();
        }
        return revisedQuality;
    }

    public void assertMinimumQualities() {
        LinkedList<String> errorTokens = new LinkedList<String>();
        for (Map.Entry<Byte, AtomicInteger> entry : this.qualityCountMap.entrySet()) {
            if (BclQualityEvaluationStrategy.generateRevisedQuality(entry.getKey()) >= this.minimumRevisedQuality) continue;
            errorTokens.add(String.format("quality %s observed %s times", entry.getKey(), entry.getValue()));
        }
        if (!errorTokens.isEmpty()) {
            throw new PicardException(String.format("Found BCL qualities that fell beneath minimum threshold of %s: %s.", this.minimumRevisedQuality, CollectionUtil.join(errorTokens, "; ")));
        }
    }

    public Map<Byte, Integer> getPoorQualityFrequencies() {
        HashMap<Byte, Integer> qualityCountMapCopy = new HashMap<Byte, Integer>();
        for (Map.Entry<Byte, AtomicInteger> entry : this.qualityCountMap.entrySet()) {
            qualityCountMapCopy.put(entry.getKey(), entry.getValue().intValue());
        }
        return Collections.unmodifiableMap(qualityCountMapCopy);
    }
}

