/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.sam;

import java.io.File;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.io.IoUtil;
import net.sf.picard.sam.AbstractAlignmentMerger;
import net.sf.picard.util.Log;
import net.sf.picard.util.ProgressLogger;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMFileWriter;
import net.sf.samtools.SAMFileWriterFactory;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordIterator;

public class CleanSam
extends CommandLineProgram {
    @Usage
    public String USAGE = this.getStandardUsagePreamble() + "Read SAM and perform various fix-ups.  " + "Currently, the only fix-ups are 1: to soft-clip an alignment that hangs off the end of its reference sequence; " + "and 2: to set MAPQ to 0 if a read is unmapped.";
    @Option(shortName="I", doc="Input SAM to be cleaned.")
    public File INPUT;
    @Option(shortName="O", doc="Where to write cleaned SAM.")
    public File OUTPUT;

    public static void main(String[] argv) {
        new CleanSam().instanceMainWithExit(argv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int doWork() {
        IoUtil.assertFileIsReadable(this.INPUT);
        IoUtil.assertFileIsWritable(this.OUTPUT);
        SAMFileReader.ValidationStringency originalStringency = SAMFileReader.getDefaultValidationStringency();
        if (this.VALIDATION_STRINGENCY == SAMFileReader.ValidationStringency.STRICT) {
            SAMFileReader.setDefaultValidationStringency(SAMFileReader.ValidationStringency.LENIENT);
        }
        try {
            SAMFileReader reader = new SAMFileReader(this.INPUT);
            SAMFileWriter writer = new SAMFileWriterFactory().makeSAMOrBAMWriter(reader.getFileHeader(), true, this.OUTPUT);
            SAMRecordIterator it = reader.iterator();
            ProgressLogger progress = new ProgressLogger(Log.getInstance(CleanSam.class));
            while (it.hasNext()) {
                SAMRecord rec = (SAMRecord)it.next();
                AbstractAlignmentMerger.createNewCigarsIfMapsOffEndOfReference(rec);
                if (rec.getReadUnmappedFlag() && 0 != rec.getMappingQuality()) {
                    rec.setMappingQuality(0);
                }
                writer.addAlignment(rec);
                progress.record(rec);
            }
            writer.close();
            it.close();
        }
        finally {
            SAMFileReader.setDefaultValidationStringency(originalStringency);
        }
        return 0;
    }
}

