/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.sam;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import net.sf.picard.PicardException;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.io.IoUtil;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMTextHeaderCodec;
import net.sf.samtools.util.AsciiWriter;

public class ViewSam
extends CommandLineProgram {
    @Usage
    public final String USAGE = this.getStandardUsagePreamble() + "Prints a SAM or BAM file to the screen.";
    @Option(shortName="I", doc="The SAM or BAM file to view.")
    public File INPUT;
    @Option(doc="Print out all reads, just the aligned reads or just the unaligned reads.")
    public AlignmentStatus ALIGNMENT_STATUS = AlignmentStatus.All;
    @Option(doc="Print out all reads, just the PF reads or just the non-PF reads.")
    public PfStatus PF_STATUS = PfStatus.All;

    public static void main(String[] args) {
        new ViewSam().instanceMain(args);
    }

    @Override
    protected int doWork() {
        return this.writeSamText(System.out);
    }

    int writeSamText(PrintStream printStream) {
        try {
            IoUtil.assertFileIsReadable(this.INPUT);
            SAMFileReader in = new SAMFileReader(this.INPUT);
            AsciiWriter writer = new AsciiWriter(printStream);
            SAMFileHeader header = in.getFileHeader();
            if (header.getTextHeader() != null) {
                writer.write(header.getTextHeader());
            } else {
                new SAMTextHeaderCodec().encode(writer, header, true);
            }
            for (SAMRecord rec : in) {
                if (printStream.checkError()) {
                    return 1;
                }
                if (this.ALIGNMENT_STATUS == AlignmentStatus.Aligned && rec.getReadUnmappedFlag() || this.ALIGNMENT_STATUS == AlignmentStatus.Unaligned && !rec.getReadUnmappedFlag() || this.PF_STATUS == PfStatus.PF && rec.getReadFailsVendorQualityCheckFlag() || this.PF_STATUS == PfStatus.NonPF && !rec.getReadFailsVendorQualityCheckFlag()) continue;
                writer.write(rec.getSAMString());
            }
            writer.flush();
            if (printStream.checkError()) {
                return 1;
            }
            return 0;
        }
        catch (IOException e) {
            throw new PicardException("Exception writing SAM text", e);
        }
    }

    public static enum PfStatus {
        PF,
        NonPF,
        All;

    }

    public static enum AlignmentStatus {
        Aligned,
        Unaligned,
        All;

    }
}

