/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.util;

import java.util.Iterator;
import net.sf.picard.PicardException;
import net.sf.picard.util.Interval;
import net.sf.picard.util.IntervalList;
import net.sf.samtools.SAMSequenceDictionary;

public class IntervalUtil {
    public static boolean contains(Interval interval, String sequenceName, long position) {
        return interval.getSequence().equals(sequenceName) && position >= (long)interval.getStart() && position <= (long)interval.getEnd();
    }

    public static boolean contains(IntervalList intervalList, String sequenceName, long position) {
        for (Interval interval : intervalList.getUniqueIntervals()) {
            if (!IntervalUtil.contains(interval, sequenceName, position)) continue;
            return true;
        }
        return false;
    }

    public static void assertOrderedNonOverlapping(Iterator<Interval> intervals, SAMSequenceDictionary sequenceDictionary) {
        if (!intervals.hasNext()) {
            return;
        }
        Interval prevInterval = intervals.next();
        int prevSequenceIndex = sequenceDictionary.getSequenceIndex(prevInterval.getSequence());
        while (intervals.hasNext()) {
            Interval interval = intervals.next();
            if (prevInterval.intersects(interval)) {
                throw new PicardException("Intervals should not overlap: " + prevInterval + "; " + interval);
            }
            int thisSequenceIndex = sequenceDictionary.getSequenceIndex(interval.getSequence());
            if (prevSequenceIndex > thisSequenceIndex || prevSequenceIndex == thisSequenceIndex && prevInterval.compareTo(interval) >= 0) {
                throw new PicardException("Intervals not in order: " + prevInterval + "; " + interval);
            }
            prevInterval = interval;
            prevSequenceIndex = thisSequenceIndex;
        }
    }
}

