/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.io.IOException;
import java.net.URI;
import net.sf.samtools.AbstractBAMFileIndex_;
import net.sf.samtools.seekablestream.SeekableStream;
import net.sf.samtools.util.RuntimeIOException;

public class SeekableStreamFileBuffer
extends AbstractBAMFileIndex_.IndexFileBuffer {
    private static final int PAGE_SIZE = 4096;
    private static final int PAGE_OFFSET_MASK = 4095;
    private static final int PAGE_MASK = -4096;
    private static final int INVALID_PAGE = 1;
    private URI mUri;
    private SeekableStream mSeekableStream;
    private int mFileLength;
    private int mFilePointer = 0;
    private int mCurrentPage = 1;
    private final byte[] mBuffer = new byte[4096];

    SeekableStreamFileBuffer(SeekableStream seekableStream, URI uri) {
        this.mSeekableStream = seekableStream;
        this.mUri = uri;
        long fileLength = seekableStream.length();
        if (fileLength > Integer.MAX_VALUE) {
            throw new RuntimeException("BAM index file " + this.mUri + " is too large: " + fileLength);
        }
        this.mFileLength = (int)fileLength;
    }

    public URI getURI() {
        return this.mUri;
    }

    @Override
    void readBytes(byte[] bytes) {
        int resultOffset = 0;
        int resultLength = bytes.length;
        if (this.mFilePointer + resultLength > this.mFileLength) {
            throw new RuntimeException("Attempt to read past end of BAM index file (file is truncated?): " + this.mUri);
        }
        while (resultLength > 0) {
            this.loadPage(this.mFilePointer);
            int pageOffset = this.mFilePointer & 0xFFF;
            int copyLength = Math.min(resultLength, 4096 - pageOffset);
            System.arraycopy(this.mBuffer, pageOffset, bytes, resultOffset, copyLength);
            this.mFilePointer += copyLength;
            resultOffset += copyLength;
            resultLength -= copyLength;
        }
    }

    @Override
    int readInteger() {
        this.loadPage(this.mFilePointer);
        int pageOffset = this.mFilePointer & 0xFFF;
        this.mFilePointer += 4;
        return this.mBuffer[pageOffset + 0] & 0xFF | (this.mBuffer[pageOffset + 1] & 0xFF) << 8 | (this.mBuffer[pageOffset + 2] & 0xFF) << 16 | (this.mBuffer[pageOffset + 3] & 0xFF) << 24;
    }

    @Override
    long readLong() {
        long lower = this.readInteger();
        long upper = this.readInteger();
        return upper << 32 | lower & 0xFFFFFFFFL;
    }

    @Override
    void skipBytes(int count) {
        this.mFilePointer += count;
    }

    @Override
    void seek(int position) {
        this.mFilePointer = position;
    }

    @Override
    void close() {
        this.mFilePointer = 0;
        this.mCurrentPage = 1;
        if (this.mSeekableStream != null) {
            try {
                this.mSeekableStream.close();
            }
            catch (IOException exc) {
                throw new RuntimeIOException(exc.getMessage(), exc);
            }
            this.mSeekableStream = null;
        }
    }

    private void loadPage(int filePosition) {
        int page = filePosition & 0xFFFFF000;
        if (page == this.mCurrentPage) {
            return;
        }
        try {
            this.mSeekableStream.seek(page);
            int readLength = Math.min(this.mFileLength - page, 4096);
            this.mSeekableStream.read(this.mBuffer, 0, readLength);
            this.mCurrentPage = page;
        }
        catch (IOException exc) {
            throw new RuntimeIOException("Exception reading BAM index file " + this.mUri + ": " + exc.getMessage(), exc);
        }
    }
}

