/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.lang.reflect.Field;
import java.net.URI;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.samtools.AbstractBAMFileIndex_;
import net.sf.samtools.BAMFileSpan;
import net.sf.samtools.BAMIndexContent;
import net.sf.samtools.Bin;
import net.sf.samtools.Chunk;
import net.sf.samtools.SAMSequenceDictionary;
import net.sf.samtools.SeekableStreamFileBuffer;
import net.sf.samtools.seekablestream.SeekableStream;

public class StubBAMFileIndex
extends AbstractBAMFileIndex_ {
    public StubBAMFileIndex(SeekableStream ss, URI uri, SAMSequenceDictionary dictionary) {
        super(dictionary, new SeekableStreamFileBuffer(ss, uri));
    }

    @Override
    public BAMFileSpan getSpanOverlapping(int referenceIndex, int startPos, int endPos) {
        return null;
    }

    @Override
    protected BAMIndexContent getQueryResults(int reference) {
        return null;
    }

    public BAMIndexContent query(int referenceSequence) {
        return this.query(referenceSequence, 1, 0x1FFFFFFF);
    }

    public Iterator<Map<Integer, List<List<Long>>>> getBinIter(int refno) {
        BAMIndexContent bic = this.query(refno);
        return this.getBinIterator(bic.getBins().iterator());
    }

    public List<List<Long>> getChunkList(Bin bin) {
        final List<Chunk> chunks = bin.getChunkList();
        return new AbstractList<List<Long>>(){

            @Override
            public List<Long> get(int index) {
                Chunk chunk = (Chunk)chunks.get(index);
                ArrayList<Long> chunkList = new ArrayList<Long>();
                try {
                    Field mChunkStart = Chunk.class.getDeclaredField("mChunkStart");
                    mChunkStart.setAccessible(true);
                    chunkList.add(mChunkStart.getLong(chunk));
                    Field mChunkEnd = Chunk.class.getDeclaredField("mChunkEnd");
                    mChunkEnd.setAccessible(true);
                    chunkList.add(mChunkEnd.getLong(chunk));
                }
                catch (Exception x) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "failed to get chunk values", x);
                }
                return chunkList;
            }

            @Override
            public int size() {
                return chunks.size();
            }
        };
    }

    private Iterator<Map<Integer, List<List<Long>>>> getBinIterator(final Iterator<Bin> blIter) {
        return new Iterator<Map<Integer, List<List<Long>>>>(){

            @Override
            public boolean hasNext() {
                return blIter.hasNext();
            }

            @Override
            public Map<Integer, List<List<Long>>> next() {
                final Bin bin = (Bin)blIter.next();
                return new AbstractMap<Integer, List<List<Long>>>(){

                    @Override
                    public Set<Map.Entry<Integer, List<List<Long>>>> entrySet() {
                        HashSet<Map.Entry<Integer, List<List<Long>>>> entrySet = new HashSet<Map.Entry<Integer, List<List<Long>>>>();
                        entrySet.add(new AbstractMap.SimpleEntry<Integer, List<List<Long>>>(bin.getBinNumber(), StubBAMFileIndex.this.getChunkList(bin)));
                        return entrySet;
                    }
                };
            }

            @Override
            public void remove() {
            }
        };
    }
}

