/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.alignment.io;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.biojava.nbio.alignment.io.StockholmConsensusAnnotation;
import org.biojava.nbio.alignment.io.StockholmFileAnnotation;
import org.biojava.nbio.alignment.io.StockholmResidueAnnotation;
import org.biojava.nbio.alignment.io.StockholmSequenceAnnotation;
import org.biojava.nbio.core.exceptions.CompoundNotFoundException;
import org.biojava.nbio.core.sequence.ProteinSequence;
import org.biojava.nbio.core.sequence.RNASequence;
import org.biojava.nbio.core.sequence.template.AbstractCompound;
import org.biojava.nbio.core.sequence.template.AbstractSequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StockholmStructure {
    private static final Logger logger = LoggerFactory.getLogger(StockholmStructure.class);
    public static final String PFAM = "PFAM";
    public static final String RFAM = "RFAM";
    private final StockholmFileAnnotation fileAnnotation = new StockholmFileAnnotation();
    private final StockholmConsensusAnnotation consAnnotation = new StockholmConsensusAnnotation();
    private final Map<String, StringBuffer> sequences = new HashMap<String, StringBuffer>();
    private final Map<String, StockholmSequenceAnnotation> seqsAnnotation = new HashMap<String, StockholmSequenceAnnotation>();
    private final Map<String, StockholmResidueAnnotation> resAnnotation = new HashMap<String, StockholmResidueAnnotation>();

    public StockholmFileAnnotation getFileAnnotation() {
        return this.fileAnnotation;
    }

    public StockholmConsensusAnnotation getConsAnnotation() {
        return this.consAnnotation;
    }

    @Deprecated
    public void addSequence(String seqName, String seqText) {
        this.appendToSequence(seqName, seqText);
    }

    public void appendToSequence(String seqName, String seqText) {
        StringBuffer seq = this.sequences.get(seqName);
        if (seq != null) {
            seq.append(seqText);
        } else {
            seq = new StringBuffer(seqText);
            this.sequences.put(seqName, seq);
        }
    }

    public Map<String, StringBuffer> getSequences() {
        return this.sequences;
    }

    private StockholmSequenceAnnotation getSequenceAnnotation(String seqName) {
        if (!this.seqsAnnotation.containsKey(seqName)) {
            this.seqsAnnotation.put(seqName, new StockholmSequenceAnnotation());
        }
        return this.seqsAnnotation.get(seqName);
    }

    public void addGSAccessionNumber(String seqName, String text) {
        this.getSequenceAnnotation(seqName).setAccessionNumber(text);
    }

    public void addGSDescription(String seqName, String text) {
        this.getSequenceAnnotation(seqName).addToDescription(text);
    }

    public void addGSdbReference(String seqName, String text) {
        this.getSequenceAnnotation(seqName).addDBReference(text);
    }

    public void addGSOrganismSpecies(String seqName, String text) {
        this.getSequenceAnnotation(seqName).setOrganism(text);
    }

    public void addGSOrganismClassification(String seqName, String text) {
        this.getSequenceAnnotation(seqName).setOrganismClassification(text);
    }

    public void addGSLook(String seqName, String text) {
        this.getSequenceAnnotation(seqName).setLook(text);
    }

    private StockholmResidueAnnotation getResidueAnnotation(String seqName) {
        if (!this.resAnnotation.containsKey(seqName)) {
            this.resAnnotation.put(seqName, new StockholmResidueAnnotation());
        }
        return this.resAnnotation.get(seqName);
    }

    public void addSurfaceAccessibility(String seqName, String text) {
        this.getResidueAnnotation(seqName).setSurfaceAccessibility(text);
    }

    public void addTransMembrane(String seqName, String text) {
        this.getResidueAnnotation(seqName).setTransMembrane(text);
    }

    public void addPosteriorProbability(String seqName, String text) {
        this.getResidueAnnotation(seqName).setPosteriorProbability(text);
    }

    public void addLigandBinding(String seqName, String text) {
        this.getResidueAnnotation(seqName).setLigandBinding(text);
    }

    public void addActiveSite(String seqName, String text) {
        this.getResidueAnnotation(seqName).setActiveSite(text);
    }

    public void addASPFamPredicted(String seqName, String text) {
        this.getResidueAnnotation(seqName).setAsPFamPredicted(text);
    }

    public void addASSwissProt(String seqName, String text) {
        this.getResidueAnnotation(seqName).setAsSwissProt(text);
    }

    public void addIntron(String seqName, String text) {
        this.getResidueAnnotation(seqName).setIntron(text);
    }

    public void addSecondaryStructure(String seqName, String text) {
        this.getResidueAnnotation(seqName).setSecondaryStructure(text);
    }

    public List<AbstractSequence<? extends AbstractCompound>> getBioSequences() {
        return this.getBioSequences(false);
    }

    public List<AbstractSequence<? extends AbstractCompound>> getBioSequences(boolean ignoreCase, String forcedSequenceType) {
        if (forcedSequenceType != null && !(forcedSequenceType.equals(PFAM) | forcedSequenceType.equals(RFAM))) {
            throw new IllegalArgumentException("Illegal Argument " + forcedSequenceType);
        }
        ArrayList<AbstractSequence<? extends AbstractCompound>> seqs = new ArrayList<AbstractSequence<? extends AbstractCompound>>();
        for (String sequencename : this.sequences.keySet()) {
            AbstractSequence seq = null;
            String sequence = this.sequences.get(sequencename).toString();
            if (ignoreCase) {
                sequence = sequence.toUpperCase();
            }
            try {
                seq = forcedSequenceType == null ? (this.fileAnnotation.isPFam() ? new ProteinSequence(sequence) : new RNASequence(sequence)) : (forcedSequenceType.equals(PFAM) ? new ProteinSequence(sequence) : new RNASequence(sequence));
            }
            catch (CompoundNotFoundException e) {
                logger.warn("Could not create sequence because of unknown compounds ({}). Sequence {} will be ignored.", (Object)e.getMessage(), (Object)sequencename);
                continue;
            }
            String[] seqDetails = this.splitSeqName(sequencename);
            seq.setDescription(seqDetails[0]);
            seq.setBioBegin(seqDetails[1] == null || seqDetails[1].trim().equals("") ? null : new Integer(seqDetails[1]));
            seq.setBioEnd(seqDetails[2] == null || seqDetails[2].trim().equals("") ? null : new Integer(seqDetails[2]));
            seqs.add(seq);
        }
        return seqs;
    }

    public List<AbstractSequence<? extends AbstractCompound>> getBioSequences(boolean ignoreCase) {
        return this.getBioSequences(ignoreCase, null);
    }

    private String[] splitSeqName(String sequenceName) {
        String[] result = new String[3];
        String[] barSplit = sequenceName.toString().split("/");
        if (barSplit.length == 2) {
            result[0] = barSplit[0];
            String[] positions = barSplit[1].split("-");
            if (positions.length == 2) {
                result[1] = positions[0];
                result[2] = positions[1];
            }
        } else {
            result[0] = sequenceName;
            result[1] = null;
            result[2] = null;
        }
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        List<AbstractSequence<? extends AbstractCompound>> bioSeqs = this.getBioSequences(false);
        int sequenceLength = -1;
        for (AbstractSequence<? extends AbstractCompound> sequence : bioSeqs) {
            String sequenceAsString = sequence.getSequenceAsString();
            sequenceLength = sequenceAsString.length();
            if (sequenceLength > 50) {
                result.append(sequenceAsString.substring(0, 40));
                result.append("...");
                result.append(sequenceAsString.substring(sequenceLength - 3, sequenceLength));
            } else {
                result.append(sequenceAsString);
            }
            result.append(" " + sequence.getDescription() + "\n");
        }
        result.append("Alignment with " + bioSeqs.size() + " rows and " + sequenceLength + " columns");
        return result.toString();
    }

    public static class DatabaseReference {
        public static final String EXPERT = "EXPERT";
        public static final String MIM = "MIM";
        public static final String PFAMB = "PFAMB";
        public static final String PRINTS = "PRINTS";
        public static final String PROSITE = "PROSITE";
        public static final String PROSITE_PROFILE = "PROSITE_PROFILE";
        public static final String SCOP = "SCOP";
        public static final String PDB = "PDB";
        public static final String SMART = "SMART";
        public static final String URL = "URL";
        public static final String LOAD = "LOAD";
        public static final String HOMSTRAD = "HOMSTRAD";
        public static final String INTERPRO = "INTERPRO";
        private final String database;
        private final String reference;

        public DatabaseReference(String database, String reference) {
            this.database = database;
            this.reference = reference;
        }

        public DatabaseReference(String representativeAnnotationString) {
            int semiColonIndex = representativeAnnotationString.indexOf(59);
            this.database = representativeAnnotationString.substring(0, semiColonIndex);
            this.reference = representativeAnnotationString.substring(semiColonIndex + 1, representativeAnnotationString.lastIndexOf(59)).trim();
        }

        public String toString() {
            return this.database + ';' + ' ' + this.reference + ';';
        }

        public String getDatabase() {
            return this.database;
        }

        public String getReference() {
            return this.reference;
        }
    }
}

