/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.phylo;

import org.biojava.nbio.phylo.ResidueProperties;

public class ScoreMatrix {
    String name;
    int[][] matrix;
    int type;

    ScoreMatrix(String name, int[][] matrix, int type) {
        this.matrix = matrix;
        this.type = type;
    }

    public boolean isDNA() {
        return this.type == 1;
    }

    public boolean isProtein() {
        return this.type == 0;
    }

    public int[][] getMatrix() {
        return this.matrix;
    }

    public int getPairwiseScore(String A1, String A2) {
        return this.getPairwiseScore(A1.charAt(0), A2.charAt(0));
    }

    public int getPairwiseScore(char c, char d) {
        int pog = 0;
        try {
            int a = this.type == 0 ? ResidueProperties.aaIndex[c] : ResidueProperties.nucleotideIndex[c];
            int b = this.type == 0 ? ResidueProperties.aaIndex[d] : ResidueProperties.nucleotideIndex[d];
            pog = this.matrix[a][b];
        }
        catch (Exception e) {
            // empty catch block
        }
        return pog;
    }
}

