/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.index.interval;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import org.broad.tribble.Feature;
import org.broad.tribble.index.Index;
import org.broad.tribble.index.TribbleIndexCreator;
import org.broad.tribble.index.interval.IntervalTreeIndex;
import org.broad.tribble.index.interval.MutableInterval;

public class IntervalIndexCreator
extends TribbleIndexCreator {
    public static int DEFAULT_FEATURE_COUNT = 600;
    private int featuresPerInterval = DEFAULT_FEATURE_COUNT;
    private final LinkedList<IntervalTreeIndex.ChrIndex> chrList = new LinkedList();
    private int featureCount = 0;
    private final ArrayList<MutableInterval> intervals = new ArrayList();
    File inputFile;

    public IntervalIndexCreator(File inputFile, int featuresPerInterval) {
        this.inputFile = inputFile;
        this.featuresPerInterval = featuresPerInterval;
    }

    public IntervalIndexCreator(File inputFile) {
        this(inputFile, DEFAULT_FEATURE_COUNT);
    }

    @Override
    public void addFeature(Feature feature, long filePosition) {
        if (this.chrList.size() == 0 || !this.chrList.getLast().getName().equals(feature.getChr())) {
            if (this.chrList.size() != 0) {
                this.addIntervalsToLastChr(filePosition);
            }
            this.chrList.add(new IntervalTreeIndex.ChrIndex(feature.getChr()));
            this.intervals.clear();
        }
        if (this.featureCount >= this.featuresPerInterval || this.intervals.size() == 0) {
            MutableInterval i = new MutableInterval();
            i.setStart(feature.getStart());
            i.setStartFilePosition(filePosition);
            if (this.intervals.size() > 0) {
                this.intervals.get(this.intervals.size() - 1).setEndFilePosition(filePosition);
            }
            this.featureCount = 0;
            this.intervals.add(i);
        }
        this.intervals.get(this.intervals.size() - 1).setStop(Math.max(feature.getEnd(), this.intervals.get(this.intervals.size() - 1).getStop()));
        ++this.featureCount;
    }

    private void addIntervalsToLastChr(long currentPos) {
        for (int x = 0; x < this.intervals.size(); ++x) {
            if (x == this.intervals.size() - 1) {
                this.intervals.get(x).setEndFilePosition(currentPos);
            }
            this.chrList.getLast().insert(this.intervals.get(x).toInterval());
        }
    }

    @Override
    public Index finalizeIndex(long finalFilePosition) {
        IntervalTreeIndex featureIndex = new IntervalTreeIndex(this.inputFile.getAbsolutePath());
        this.addIntervalsToLastChr(finalFilePosition);
        featureIndex.setChrIndex(this.chrList);
        featureIndex.addProperties(this.properties);
        featureIndex.finalizeIndex();
        return featureIndex;
    }

    public int getFeaturesPerInterval() {
        return this.featuresPerInterval;
    }
}

