/*
 * Decompiled with CFR 0.152.
 */
package org.forester.application;

import java.io.File;
import java.io.FileInputStream;
import org.forester.io.parsers.GeneralMsaParser;
import org.forester.msa.Msa;
import org.forester.msa.MsaMethods;
import org.forester.util.BasicDescriptiveStatistics;
import org.forester.util.CommandLineArguments;
import org.forester.util.DescriptiveStatistics;
import org.forester.util.ForesterUtil;

public class mcc {
    private static final String HELP_OPTION_1 = "help";
    private static final String HELP_OPTION_2 = "h";
    private static final String FROM_OPTION = "f";
    private static final String TO_OPTION = "t";
    private static final String STEP_OPTION = "s";
    private static final String WINDOW_OPTION = "w";
    private static final String PRG_NAME = "mcc";
    private static final String PRG_DESC = "msa consensus conservation";
    private static final String PRG_VERSION = "1.00";
    private static final String PRG_DATE = "2012.05.18";
    private static final String E_MAIL = "phylosoft@gmail.com";
    private static final String WWW = "www.phylosoft.org/forester/";

    public static void main(String[] stringArray) {
        try {
            CommandLineArguments commandLineArguments = new CommandLineArguments(stringArray);
            if (commandLineArguments.isOptionSet(HELP_OPTION_1) || commandLineArguments.isOptionSet(HELP_OPTION_2) || stringArray.length != 3) {
                mcc.printHelp();
                System.exit(0);
            }
            File file = commandLineArguments.getFile(0);
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            if (commandLineArguments.isOptionSet(FROM_OPTION) && commandLineArguments.isOptionSet(TO_OPTION)) {
                n = commandLineArguments.getOptionValueAsInt(FROM_OPTION);
                n2 = commandLineArguments.getOptionValueAsInt(TO_OPTION);
            } else if (commandLineArguments.isOptionSet(STEP_OPTION) && commandLineArguments.isOptionSet(WINDOW_OPTION)) {
                n4 = commandLineArguments.getOptionValueAsInt(STEP_OPTION);
                n3 = commandLineArguments.getOptionValueAsInt(WINDOW_OPTION);
            } else {
                mcc.printHelp();
                System.exit(0);
            }
            Msa msa = null;
            msa = GeneralMsaParser.parse(new FileInputStream(file));
            if (commandLineArguments.isOptionSet(FROM_OPTION)) {
                mcc.singleCalc(file, n, n2, msa);
            } else {
                mcc.windowedCalcs(n3, n4, msa);
            }
        }
        catch (Exception exception) {
            ForesterUtil.fatalError(PRG_NAME, exception.getMessage());
        }
    }

    private static void printHelp() {
        ForesterUtil.printProgramInformation(PRG_NAME, PRG_DESC, PRG_VERSION, PRG_DATE, E_MAIL, WWW, ForesterUtil.getForesterLibraryInformation());
        System.out.println("Usage:");
        System.out.println();
        System.out.println("mcc <options> <msa input file>");
        System.out.println();
        System.out.println(" options: ");
        System.out.println();
        System.out.println("   -f=<integer>: from (msa column)");
        System.out.println("   -t=<integer>: to (msa column)");
        System.out.println("    or");
        System.out.println("   -w=<integer>: window size (msa columns)");
        System.out.println("   -s=<integer>: step size (msa columns)");
        System.out.println();
        System.out.println();
        System.out.println();
    }

    private static void windowedCalcs(int n, int n2, Msa msa) {
        if (n < 1) {
            n = 1;
        }
        if (n2 < 1) {
            n2 = 1;
        }
        double[] dArray = new double[msa.getLength()];
        for (int i = 0; i <= msa.getLength() - 1; ++i) {
            dArray[i] = MsaMethods.calculateIdentityRatio(msa, i);
        }
        String string = "";
        String string2 = "";
        double d = 1.0;
        double d2 = 0.0;
        for (int i = 0; i <= msa.getLength() - 1; i += n2) {
            int n3 = i + n - 1;
            if (n3 > msa.getLength() - 1) {
                n3 = msa.getLength() - 1;
            }
            DescriptiveStatistics descriptiveStatistics = mcc.calc(i, n3, dArray);
            double d3 = descriptiveStatistics.arithmeticMean();
            String string3 = i + "-" + n3;
            System.out.print(string3);
            System.out.print(":\t");
            System.out.print(d3);
            if (descriptiveStatistics.getN() > 2) {
                System.out.print("\t");
                System.out.print(descriptiveStatistics.median());
                System.out.print("\t");
                System.out.print(descriptiveStatistics.sampleStandardDeviation());
            }
            System.out.println();
            if (d3 > d2) {
                d2 = d3;
                string2 = string3;
            }
            if (!(d3 < d)) continue;
            d = d3;
            string = string3;
        }
        System.out.println("Min: " + string + ": " + d);
        System.out.println("Max: " + string2 + ": " + d2);
    }

    private static void singleCalc(File file, int n, int n2, Msa msa) {
        if (n < 0) {
            n = 0;
        }
        if (n2 > msa.getLength() - 1) {
            n2 = msa.getLength() - 1;
        }
        DescriptiveStatistics descriptiveStatistics = mcc.calc(n, n2, msa);
        System.out.println(file.toString() + ": " + n + "-" + n2 + ":");
        System.out.println();
        System.out.println(descriptiveStatistics.toString());
    }

    private static DescriptiveStatistics calc(int n, int n2, Msa msa) {
        BasicDescriptiveStatistics basicDescriptiveStatistics = new BasicDescriptiveStatistics();
        for (int i = n; i <= n2; ++i) {
            basicDescriptiveStatistics.addValue(MsaMethods.calculateIdentityRatio(msa, i));
        }
        return basicDescriptiveStatistics;
    }

    private static DescriptiveStatistics calc(int n, int n2, double[] dArray) {
        BasicDescriptiveStatistics basicDescriptiveStatistics = new BasicDescriptiveStatistics();
        for (int i = n; i <= n2; ++i) {
            basicDescriptiveStatistics.addValue(dArray[i]);
        }
        return basicDescriptiveStatistics;
    }
}

