/*
 * Decompiled with CFR 0.152.
 */
package org.forester.application;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.forester.io.parsers.PhylogenyParser;
import org.forester.io.parsers.util.ParserUtils;
import org.forester.io.writers.PhylogenyWriter;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.util.CommandLineArguments;
import org.forester.util.ForesterUtil;

public class nhx_too {
    private static final String PRG_NAME = "nhx_too";
    private static final String PRG_VERSION = "0.1";
    private static final String PRG_DATE = "2008.03.04";
    private static final String INT_NODE_NAME_IS_SUPPORT = "is";

    public static void main(String[] stringArray) {
        Object object;
        ForesterUtil.printProgramInformation(PRG_NAME, PRG_VERSION, PRG_DATE);
        if (stringArray.length < 3 || stringArray.length > 3) {
            System.out.println();
            System.out.println("nhx_too: wrong number of arguments");
            System.out.println();
            System.out.println("Usage: \"nhx_too [options] <infile> <outfile>\n");
            System.out.println(" Options: -is: internal node names are support values (i.e. MrBayes output)");
            System.out.println();
            System.exit(-1);
        }
        CommandLineArguments commandLineArguments = null;
        try {
            commandLineArguments = new CommandLineArguments(stringArray);
        }
        catch (Exception exception) {
            ForesterUtil.fatalError(PRG_NAME, exception.getMessage());
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(INT_NODE_NAME_IS_SUPPORT);
        String string = commandLineArguments.validateAllowedOptionsAsString(arrayList);
        if (string.length() > 0) {
            ForesterUtil.fatalError(PRG_NAME, "Unknown option(s): " + string);
        }
        File file = commandLineArguments.getFile(0);
        File file2 = commandLineArguments.getFile(1);
        boolean bl = false;
        if (commandLineArguments.isOptionSet(INT_NODE_NAME_IS_SUPPORT)) {
            bl = true;
        }
        Phylogeny phylogeny = null;
        try {
            object = ParserBasedPhylogenyFactory.getInstance();
            PhylogenyParser phylogenyParser = ParserUtils.createParserDependingOnFileType(file, true);
            phylogeny = object.create(file, phylogenyParser)[0];
        }
        catch (Exception exception) {
            ForesterUtil.fatalError(PRG_NAME, "Could not read \"" + file + "\" [" + exception.getMessage() + "]");
        }
        if (bl) {
            try {
                PhylogenyMethods.transferInternalNodeNamesToConfidence(phylogeny);
            }
            catch (Exception exception) {
                ForesterUtil.unexpectedFatalError(PRG_NAME, "Failure during moving of internal names to support values [" + exception.getMessage() + "]");
            }
        }
        try {
            object = new PhylogenyWriter();
            ((PhylogenyWriter)object).toNewHampshireX(phylogeny, file2);
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError(PRG_NAME, "Failure to write output [" + iOException.getMessage() + "]");
        }
        System.out.println();
        System.out.println("Done [wrote \"" + file2 + "\"].");
        System.out.println();
    }
}

