/*
 * Decompiled with CFR 0.152.
 */
package org.forester.application;

import java.io.File;
import java.io.IOException;
import org.forester.io.parsers.PhylogenyParser;
import org.forester.io.parsers.util.ParserUtils;
import org.forester.io.writers.PhylogenyWriter;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;

public class strip {
    public static void main(String[] stringArray) {
        if (stringArray.length < 4) {
            System.out.println("\nstrip: Wrong number of arguments.\n");
            System.out.println("Usage: \"strip <infile> <outfile> <options> [name1] [name2] ... OR [phylogenyfile]\"\n");
            System.out.println(" Options: -k to keep listed nodes");
            System.out.println("          -r to remove listed nodes");
            System.out.println("          -kp to keep nodes found in [phylogenyfile]");
            System.out.println("          -rp to remove nodes found in [phylogenyfile]\n");
            System.exit(-1);
        }
        File file = new File(stringArray[0]);
        File file2 = new File(stringArray[1]);
        String string = stringArray[2];
        Phylogeny phylogeny = null;
        try {
            PhylogenyFactory phylogenyFactory = ParserBasedPhylogenyFactory.getInstance();
            PhylogenyParser phylogenyParser = ParserUtils.createParserDependingOnFileType(file, true);
            phylogeny = phylogenyFactory.create(file, phylogenyParser)[0];
        }
        catch (Exception exception) {
            System.out.println("\nCould not read \"" + file + "\" [" + exception.getMessage() + "]\n");
            System.exit(-1);
        }
        boolean bl = false;
        boolean bl2 = false;
        if (string.trim().toLowerCase().equals("-k")) {
            bl = true;
        } else if (string.trim().toLowerCase().equals("-kp")) {
            bl = true;
            bl2 = true;
        } else if (string.trim().toLowerCase().equals("-rp")) {
            bl2 = true;
        } else if (!string.trim().toLowerCase().equals("-r")) {
            System.out.println("\nUnknown option \"" + string + "\"\n");
            System.exit(-1);
        }
        String[] stringArray2 = null;
        if (bl2) {
            stringArray2 = strip.readInNamesFromPhylogeny(stringArray[3]);
        } else {
            stringArray2 = new String[stringArray.length - 3];
            for (int i = 0; i < stringArray.length - 3; ++i) {
                stringArray2[i] = stringArray[i + 3];
            }
        }
        if (bl) {
            PhylogenyMethods.deleteExternalNodesPositiveSelection(stringArray2, phylogeny);
        } else {
            PhylogenyMethods.deleteExternalNodesNegativeSelection(stringArray2, phylogeny);
        }
        try {
            PhylogenyWriter phylogenyWriter = new PhylogenyWriter();
            phylogenyWriter.toPhyloXML(file2, phylogeny, 1);
        }
        catch (IOException iOException) {
            System.out.println("\nFailure to write output [" + iOException.getMessage() + "]\n");
            System.exit(-1);
        }
    }

    private static String[] readInNamesFromPhylogeny(String string) {
        Phylogeny phylogeny = null;
        try {
            PhylogenyFactory phylogenyFactory = ParserBasedPhylogenyFactory.getInstance();
            File file = new File(string);
            PhylogenyParser phylogenyParser = ParserUtils.createParserDependingOnFileType(file, true);
            phylogeny = phylogenyFactory.create(file, phylogenyParser)[0];
        }
        catch (Exception exception) {
            System.out.println("\nCould not read \"" + string + "\" [" + exception.getMessage() + "]\n");
            System.exit(-1);
        }
        return phylogeny.getAllExternalNodeNames();
    }
}

