/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.text.ParseException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.JApplet;
import javax.swing.JOptionPane;
import javax.swing.text.MaskFormatter;
import org.forester.analysis.TaxonomyDataManager;
import org.forester.archaeopteryx.Configuration;
import org.forester.archaeopteryx.ControlPanel;
import org.forester.archaeopteryx.MainFrameApplication;
import org.forester.archaeopteryx.MainPanel;
import org.forester.archaeopteryx.Options;
import org.forester.archaeopteryx.TreePanel;
import org.forester.io.parsers.PhylogenyParser;
import org.forester.io.parsers.phyloxml.PhyloXmlUtil;
import org.forester.io.parsers.tol.TolParser;
import org.forester.io.parsers.util.ParserUtils;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Accession;
import org.forester.phylogeny.data.BranchColor;
import org.forester.phylogeny.data.Date;
import org.forester.phylogeny.data.Distribution;
import org.forester.phylogeny.data.Sequence;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.phylogeny.iterators.PreorderTreeIterator;
import org.forester.util.AsciiHistogram;
import org.forester.util.DescriptiveStatistics;
import org.forester.util.ForesterUtil;
import org.forester.ws.seqdb.UniProtTaxonomy;

public final class AptxUtil {
    private static final Pattern seq_identifier_pattern_1 = Pattern.compile("^([A-Za-z]{2,5})[|=:]([0-9A-Za-z_\\.]{5,40})\\s*$");
    private static final Pattern seq_identifier_pattern_2 = Pattern.compile("^([A-Za-z]{2,5})[|=:]([0-9A-Za-z_\\.]{5,40})[|,; ].*$");
    private static final String[] AVAILABLE_FONT_FAMILIES_SORTED = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();

    public static final Accession obtainSequenceAccessionFromName(String string) {
        String string2 = string.trim();
        Matcher matcher = seq_identifier_pattern_1.matcher(string2);
        String string3 = "";
        String string4 = "";
        if (matcher.matches()) {
            string3 = matcher.group(1);
            string4 = matcher.group(2);
        } else {
            Matcher matcher2 = seq_identifier_pattern_2.matcher(string2);
            if (matcher2.matches()) {
                string3 = matcher2.group(1);
                string4 = matcher2.group(2);
            }
        }
        if (ForesterUtil.isEmpty(string3) || ForesterUtil.isEmpty(string4)) {
            return null;
        }
        return new Accession(string4, string3);
    }

    public static void ensurePresenceOfTaxonomy(PhylogenyNode phylogenyNode) {
        if (!phylogenyNode.getNodeData().isHasTaxonomy()) {
            phylogenyNode.getNodeData().setTaxonomy(new Taxonomy());
        }
    }

    public static void ensurePresenceOfSequence(PhylogenyNode phylogenyNode) {
        if (!phylogenyNode.getNodeData().isHasSequence()) {
            phylogenyNode.getNodeData().setSequence(new Sequence());
        }
    }

    public static final void ensurePresenceOfDistribution(PhylogenyNode phylogenyNode) {
        if (!phylogenyNode.getNodeData().isHasDistribution()) {
            phylogenyNode.getNodeData().setDistribution(new Distribution(""));
        }
    }

    public static final void ensurePresenceOfDate(PhylogenyNode phylogenyNode) {
        if (!phylogenyNode.getNodeData().isHasDate()) {
            phylogenyNode.getNodeData().setDate(new Date());
        }
    }

    public static final boolean isHasAtLeastOneBranchWithSupportValues(Phylogeny phylogeny) {
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
        while (phylogenyNodeIterator.hasNext()) {
            if (!phylogenyNodeIterator.next().getBranchData().isHasConfidences()) continue;
            return true;
        }
        return false;
    }

    public static void writePhylogenyToGraphicsFile(File file, File file2, int n, int n2, GraphicsExportType graphicsExportType, Configuration configuration) throws IOException {
        PhylogenyParser phylogenyParser = ParserUtils.createParserDependingOnFileType(file, true);
        Phylogeny[] phylogenyArray = null;
        phylogenyArray = PhylogenyMethods.readPhylogenies(phylogenyParser, file);
        AptxUtil.writePhylogenyToGraphicsFile(phylogenyArray[0], file2, n, n2, graphicsExportType, configuration);
    }

    public static void writePhylogenyToGraphicsFile(Phylogeny phylogeny, File file, int n, int n2, GraphicsExportType graphicsExportType, Configuration configuration) throws IOException {
        Phylogeny[] phylogenyArray = new Phylogeny[]{phylogeny};
        MainFrameApplication mainFrameApplication = MainFrameApplication.createInstance(phylogenyArray, configuration);
        AptxUtil.writePhylogenyToGraphicsFileNonInteractive(file, n, n2, mainFrameApplication.getMainPanel().getCurrentTreePanel(), mainFrameApplication.getMainPanel().getControlPanel(), graphicsExportType, mainFrameApplication.getOptions());
        mainFrameApplication.end();
    }

    public static final boolean isHasAtLeastOneBranchLengthLargerThanZero(Phylogeny phylogeny) {
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
        while (phylogenyNodeIterator.hasNext()) {
            if (!(phylogenyNodeIterator.next().getDistanceToParent() > 0.0)) continue;
            return true;
        }
        return false;
    }

    public static final boolean isHasAtLeastNodeWithEvent(Phylogeny phylogeny) {
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
        while (phylogenyNodeIterator.hasNext()) {
            if (!phylogenyNodeIterator.next().getNodeData().isHasEvent()) continue;
            return true;
        }
        return false;
    }

    public static MaskFormatter createMaskFormatter(String string) {
        MaskFormatter maskFormatter = null;
        try {
            maskFormatter = new MaskFormatter(string);
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException(parseException);
        }
        return maskFormatter;
    }

    static final void addPhylogeniesToTabs(Phylogeny[] phylogenyArray, String string, String string2, Configuration configuration, MainPanel mainPanel) {
        if (phylogenyArray.length > 100) {
            JOptionPane.showMessageDialog(mainPanel, "Attempt to load " + phylogenyArray.length + " phylogenies,\ngoing to load only the first " + 100, "Archaeopteryx more than 100 phylogenies", 2);
        }
        int n = 1;
        for (Phylogeny phylogeny : phylogenyArray) {
            CharSequence charSequence;
            if (phylogeny.isEmpty() || n > 100) continue;
            String string3 = "";
            String string4 = "";
            if (phylogenyArray.length > 1) {
                if (!ForesterUtil.isEmpty(string)) {
                    string3 = new String(string);
                }
                if (!ForesterUtil.isEmpty(string2)) {
                    string4 = new String(string2);
                } else if (!ForesterUtil.isEmpty(string)) {
                    string4 = new String(string);
                }
                charSequence = "";
                if (string4.indexOf(46) > 0) {
                    charSequence = string4.substring(string4.lastIndexOf(46), string4.length());
                    string4 = string4.substring(0, string4.lastIndexOf(46));
                }
                if (!ForesterUtil.isEmpty(string4)) {
                    string4 = string4 + "_";
                }
                if (!ForesterUtil.isEmpty(phylogeny.getName())) {
                    string4 = string4 + phylogeny.getName().replaceAll(" ", "_");
                } else if (phylogeny.getIdentifier() != null) {
                    StringBuffer stringBuffer = new StringBuffer();
                    if (!ForesterUtil.isEmpty(phylogeny.getIdentifier().getProvider())) {
                        stringBuffer.append(phylogeny.getIdentifier().getProvider());
                        stringBuffer.append("_");
                    }
                    stringBuffer.append(phylogeny.getIdentifier().getValue());
                    string4 = string4 + stringBuffer;
                } else {
                    string4 = string4 + n;
                }
                if (!ForesterUtil.isEmpty(string3) && ForesterUtil.isEmpty(phylogeny.getName()) && phylogeny.getIdentifier() == null) {
                    string3 = string3 + " [" + n + "]";
                }
                if (!ForesterUtil.isEmpty((String)charSequence)) {
                    string4 = string4 + (String)charSequence;
                }
            } else {
                if (!ForesterUtil.isEmpty(string)) {
                    string3 = new String(string);
                }
                string4 = "";
                if (!ForesterUtil.isEmpty(string2)) {
                    string4 = new String(string2);
                } else if (!ForesterUtil.isEmpty(string)) {
                    string4 = new String(string);
                }
                if (ForesterUtil.isEmpty(string4)) {
                    if (!ForesterUtil.isEmpty(phylogeny.getName())) {
                        string4 = new String(phylogeny.getName()).replaceAll(" ", "_");
                    } else if (phylogeny.getIdentifier() != null) {
                        charSequence = new StringBuffer();
                        if (!ForesterUtil.isEmpty(phylogeny.getIdentifier().getProvider())) {
                            ((StringBuffer)charSequence).append(phylogeny.getIdentifier().getProvider());
                            ((StringBuffer)charSequence).append("_");
                        }
                        ((StringBuffer)charSequence).append(phylogeny.getIdentifier().getValue());
                        string4 = new String(((StringBuffer)charSequence).toString().replaceAll(" ", "_"));
                    }
                }
            }
            mainPanel.addPhylogenyInNewTab(phylogeny, configuration, string3, string2);
            mainPanel.getCurrentTreePanel().setTreeFile(new File(string4));
            AptxUtil.lookAtSomeTreePropertiesForAptxControlSettings(phylogeny, mainPanel.getControlPanel(), configuration);
            ++n;
        }
    }

    static final void addPhylogenyToPanel(Phylogeny[] phylogenyArray, Configuration configuration, MainPanel mainPanel) {
        Phylogeny phylogeny = phylogenyArray[0];
        mainPanel.addPhylogenyInPanel(phylogeny, configuration);
        AptxUtil.lookAtSomeTreePropertiesForAptxControlSettings(phylogeny, mainPanel.getControlPanel(), configuration);
    }

    static final Color calculateColorFromString(String string) {
        String string2 = string.toUpperCase();
        char c = string2.charAt(0);
        int n = 32;
        char c2 = ' ';
        if (string2.length() > 1) {
            n = string2.charAt(1);
            if (string2.length() > 2) {
                c2 = string2.indexOf(" ") > 0 ? string2.charAt(string2.indexOf(" ") + 1) : string2.charAt(2);
            }
        }
        c = AptxUtil.normalizeCharForRGB(c);
        n = AptxUtil.normalizeCharForRGB((char)n);
        c2 = AptxUtil.normalizeCharForRGB(c2);
        if (c > '\u00eb' && n > 235 && c2 > '\u00eb') {
            c = '\u0000';
        } else if (c < 'P' && n < 80 && c2 < 'P') {
            n = 255;
        }
        return new Color(c, n, c2);
    }

    static final boolean canWriteFormat(String string) {
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName(string);
        return iterator.hasNext();
    }

    public static final void collapseSpeciesSpecificSubtrees(Phylogeny phylogeny) {
        boolean bl = false;
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPreorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (phylogenyNode.isExternal() || phylogenyNode.isCollapse() || phylogenyNode.getNumberOfDescendants() <= 1) continue;
            Set<Taxonomy> set = PhylogenyMethods.obtainDistinctTaxonomies(phylogenyNode);
            if (set != null && set.size() == 1) {
                AptxUtil.collapseSubtree(phylogenyNode, true);
                if (!phylogenyNode.getNodeData().isHasTaxonomy()) {
                    phylogenyNode.getNodeData().setTaxonomy((Taxonomy)phylogenyNode.getAllExternalDescendants().get(0).getNodeData().getTaxonomy().copy());
                }
                bl = true;
                continue;
            }
            phylogenyNode.setCollapse(false);
        }
        if (bl) {
            phylogeny.setRerootable(false);
        }
    }

    static final void collapseSubtree(PhylogenyNode phylogenyNode, boolean bl) {
        phylogenyNode.setCollapse(bl);
        if (phylogenyNode.isExternal()) {
            return;
        }
        PreorderTreeIterator preorderTreeIterator = new PreorderTreeIterator(phylogenyNode);
        while (preorderTreeIterator.hasNext()) {
            preorderTreeIterator.next().setCollapse(bl);
        }
    }

    static final void colorPhylogenyAccordingToConfidenceValues(Phylogeny phylogeny, TreePanel treePanel) {
        Object object;
        double d = 0.0;
        Object object2 = phylogeny.iteratorPreorder();
        while (object2.hasNext()) {
            double d2;
            object = object2.next();
            ((PhylogenyNode)object).getBranchData().setBranchColor(null);
            if (!((PhylogenyNode)object).getBranchData().isHasConfidences() || !((d2 = PhylogenyMethods.getConfidenceValue((PhylogenyNode)object)) > d)) continue;
            d = d2;
        }
        if (d > 0.0) {
            object2 = treePanel.getTreeColorSet().getBackgroundColor();
            object = treePanel.getTreeColorSet().getBranchColor();
            PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPreorder();
            while (phylogenyNodeIterator.hasNext()) {
                PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
                if (!phylogenyNode.getBranchData().isHasConfidences()) continue;
                double d3 = PhylogenyMethods.getConfidenceValue(phylogenyNode);
                BranchColor branchColor = new BranchColor(ForesterUtil.calcColor(d3, 0.0, d, (Color)object2, (Color)object));
                AptxUtil.colorizeSubtree(phylogenyNode, branchColor);
            }
        }
    }

    static final int colorPhylogenyAccordingToRanks(Phylogeny phylogeny, String string, TreePanel treePanel) {
        PhylogenyNode phylogenyNode;
        HashMap<String, Color> hashMap = new HashMap<String, Color>();
        int n = 0;
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
        while (phylogenyNodeIterator.hasNext()) {
            phylogenyNode = phylogenyNodeIterator.next();
            if (!phylogenyNode.getNodeData().isHasTaxonomy() || ForesterUtil.isEmpty(phylogenyNode.getNodeData().getTaxonomy().getScientificName()) && ForesterUtil.isEmpty(phylogenyNode.getNodeData().getTaxonomy().getCommonName()) && ForesterUtil.isEmpty(phylogenyNode.getNodeData().getTaxonomy().getTaxonomyCode()) || ForesterUtil.isEmpty(phylogenyNode.getNodeData().getTaxonomy().getRank()) || !phylogenyNode.getNodeData().getTaxonomy().getRank().equalsIgnoreCase(string)) continue;
            BranchColor branchColor = new BranchColor(treePanel.calculateTaxonomyBasedColor(phylogenyNode.getNodeData().getTaxonomy()));
            AptxUtil.colorizeSubtree(phylogenyNode, branchColor);
            ++n;
            if (ForesterUtil.isEmpty(phylogenyNode.getNodeData().getTaxonomy().getScientificName())) continue;
            hashMap.put(phylogenyNode.getNodeData().getTaxonomy().getScientificName(), branchColor.getValue());
        }
        phylogenyNodeIterator = phylogeny.iteratorPostorder();
        block3: while (phylogenyNodeIterator.hasNext()) {
            phylogenyNode = phylogenyNodeIterator.next();
            if (phylogenyNode.getBranchData().getBranchColor() != null || !phylogenyNode.getNodeData().isHasTaxonomy() || ForesterUtil.isEmpty(phylogenyNode.getNodeData().getTaxonomy().getLineage())) continue;
            boolean bl = false;
            if (!hashMap.isEmpty()) {
                for (String string2 : phylogenyNode.getNodeData().getTaxonomy().getLineage()) {
                    if (!hashMap.containsKey(string2)) continue;
                    AptxUtil.colorizeSubtree(phylogenyNode, new BranchColor((Color)hashMap.get(string2)));
                    ++n;
                    bl = true;
                    break;
                }
            }
            if (bl) continue;
            Map<String, String> map = MainPanel.getLineageToRankMap();
            for (String string3 : phylogenyNode.getNodeData().getTaxonomy().getLineage()) {
                Object object;
                Taxonomy taxonomy = new Taxonomy();
                taxonomy.setScientificName(string3);
                if (map.containsKey(string3) && !ForesterUtil.isEmpty((String)map.get(string3)) && ((String)map.get(string3)).equalsIgnoreCase(string)) {
                    object = new BranchColor(treePanel.calculateTaxonomyBasedColor(taxonomy));
                    AptxUtil.colorizeSubtree(phylogenyNode, (BranchColor)object);
                    ++n;
                    hashMap.put(string3, ((BranchColor)object).getValue());
                    continue block3;
                }
                object = null;
                try {
                    object = TaxonomyDataManager.obtainUniProtTaxonomy(taxonomy, null, null);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (object == null || ForesterUtil.isEmpty(((UniProtTaxonomy)object).getRank())) continue;
                map.put(string3, ((UniProtTaxonomy)object).getRank());
                if (!((UniProtTaxonomy)object).getRank().equalsIgnoreCase(string)) continue;
                BranchColor branchColor = new BranchColor(treePanel.calculateTaxonomyBasedColor(taxonomy));
                AptxUtil.colorizeSubtree(phylogenyNode, branchColor);
                ++n;
                hashMap.put(string3, branchColor.getValue());
                continue block3;
            }
        }
        return n;
    }

    private static void colorizeSubtree(PhylogenyNode phylogenyNode, BranchColor branchColor) {
        phylogenyNode.getBranchData().setBranchColor(branchColor);
        List<PhylogenyNode> list = PhylogenyMethods.getAllDescendants(phylogenyNode);
        for (PhylogenyNode phylogenyNode2 : list) {
            phylogenyNode2.getBranchData().setBranchColor(branchColor);
        }
    }

    static final String[] getAllRanks(Phylogeny phylogeny) {
        TreeSet<String> treeSet = new TreeSet<String>();
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPreorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (!phylogenyNode.getNodeData().isHasTaxonomy() || ForesterUtil.isEmpty(phylogenyNode.getNodeData().getTaxonomy().getRank())) continue;
            treeSet.add(phylogenyNode.getNodeData().getTaxonomy().getRank());
        }
        return ForesterUtil.stringSetToArray(treeSet);
    }

    public static String[] getAllPossibleRanks() {
        String[] stringArray = new String[PhyloXmlUtil.TAXONOMY_RANKS_LIST.size() - 2];
        int n = 0;
        for (String string : PhyloXmlUtil.TAXONOMY_RANKS_LIST) {
            if (string.equals("unknown") || string.equals("other")) continue;
            stringArray[n++] = string;
        }
        return stringArray;
    }

    static final void colorPhylogenyAccordingToExternalTaxonomy(Phylogeny phylogeny, TreePanel treePanel) {
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPreorder();
        while (phylogenyNodeIterator.hasNext()) {
            phylogenyNodeIterator.next().getBranchData().setBranchColor(null);
        }
        phylogenyNodeIterator = phylogeny.iteratorPreorder();
        while (phylogenyNodeIterator.hasNext()) {
            Taxonomy taxonomy;
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (phylogenyNode.getBranchData().isHasBranchColor() || (taxonomy = PhylogenyMethods.getExternalDescendantsTaxonomy(phylogenyNode)) == null) continue;
            phylogenyNode.getBranchData().setBranchColor(new BranchColor(treePanel.calculateTaxonomyBasedColor(taxonomy)));
            List<PhylogenyNode> list = PhylogenyMethods.getAllDescendants(phylogenyNode);
            for (PhylogenyNode phylogenyNode2 : list) {
                phylogenyNode2.getBranchData().setBranchColor(new BranchColor(treePanel.calculateTaxonomyBasedColor(taxonomy)));
            }
        }
    }

    static final String createBasicInformation(Phylogeny phylogeny) {
        StringBuilder stringBuilder = new StringBuilder();
        if (phylogeny != null && !phylogeny.isEmpty()) {
            Object object;
            if (!ForesterUtil.isEmpty(phylogeny.getName())) {
                stringBuilder.append("Name: ");
                stringBuilder.append(phylogeny.getName());
                stringBuilder.append("\n");
            }
            if (phylogeny.getIdentifier() != null) {
                stringBuilder.append("Id: ");
                stringBuilder.append(phylogeny.getIdentifier());
                stringBuilder.append("\n");
            }
            stringBuilder.append("Rooted: ");
            stringBuilder.append(phylogeny.isRooted());
            stringBuilder.append("\n");
            stringBuilder.append("Rerootable: ");
            stringBuilder.append(phylogeny.isRerootable());
            stringBuilder.append("\n");
            stringBuilder.append("Node sum: ");
            stringBuilder.append(phylogeny.getNodeCount());
            stringBuilder.append("\n");
            stringBuilder.append("External node sum: ");
            stringBuilder.append(phylogeny.getNumberOfExternalNodes());
            stringBuilder.append("\n");
            stringBuilder.append("Internal node sum: ");
            stringBuilder.append(phylogeny.getNodeCount() - phylogeny.getNumberOfExternalNodes());
            stringBuilder.append("\n");
            stringBuilder.append("Branche sum: ");
            stringBuilder.append(phylogeny.getNumberOfBranches());
            stringBuilder.append("\n");
            stringBuilder.append("Depth: ");
            stringBuilder.append(PhylogenyMethods.calculateMaxDepth(phylogeny));
            stringBuilder.append("\n");
            stringBuilder.append("Maximum distance to root: ");
            stringBuilder.append(ForesterUtil.round(PhylogenyMethods.calculateMaxDistanceToRoot(phylogeny), 6));
            stringBuilder.append("\n");
            Set<Taxonomy> set = PhylogenyMethods.obtainDistinctTaxonomies(phylogeny.getRoot());
            if (set != null) {
                stringBuilder.append("Distinct external taxonomies: ");
                stringBuilder.append(set.size());
            }
            stringBuilder.append("\n");
            DescriptiveStatistics descriptiveStatistics = PhylogenyMethods.calculatBranchLengthStatistics(phylogeny);
            if (descriptiveStatistics.getN() > 2) {
                stringBuilder.append("\n");
                stringBuilder.append("Branch-length statistics: ");
                stringBuilder.append("\n");
                stringBuilder.append("    Number of branches with non-negative branch-lengths: " + descriptiveStatistics.getN());
                stringBuilder.append("\n");
                stringBuilder.append("    Median: " + ForesterUtil.round(descriptiveStatistics.median(), 6));
                stringBuilder.append("\n");
                stringBuilder.append("    Mean: " + ForesterUtil.round(descriptiveStatistics.arithmeticMean(), 6));
                stringBuilder.append("\n");
                stringBuilder.append("    SD: " + ForesterUtil.round(descriptiveStatistics.sampleStandardDeviation(), 6));
                stringBuilder.append("\n");
                stringBuilder.append("    Minimum: " + ForesterUtil.round(descriptiveStatistics.getMin(), 6));
                stringBuilder.append("\n");
                stringBuilder.append("    Maximum: " + ForesterUtil.round(descriptiveStatistics.getMax(), 6));
                stringBuilder.append("\n");
                stringBuilder.append("\n");
                object = new AsciiHistogram(descriptiveStatistics);
                stringBuilder.append(((AsciiHistogram)object).toStringBuffer(12, '#', 40, 7, "    "));
            }
            if ((object = PhylogenyMethods.calculatNumberOfDescendantsPerNodeStatistics(phylogeny)).getN() > 2) {
                stringBuilder.append("\n");
                stringBuilder.append("Descendants per node statistics: ");
                stringBuilder.append("\n");
                stringBuilder.append("    Median: " + ForesterUtil.round(object.median(), 2));
                stringBuilder.append("\n");
                stringBuilder.append("    Mean: " + ForesterUtil.round(object.arithmeticMean(), 2));
                stringBuilder.append("\n");
                stringBuilder.append("    SD: " + ForesterUtil.round(object.sampleStandardDeviation(), 2));
                stringBuilder.append("\n");
                stringBuilder.append("    Minimum: " + ForesterUtil.roundToInt(object.getMin()));
                stringBuilder.append("\n");
                stringBuilder.append("    Maximum: " + ForesterUtil.roundToInt(object.getMax()));
                stringBuilder.append("\n");
            }
            List<DescriptiveStatistics> list = null;
            try {
                list = PhylogenyMethods.calculatConfidenceStatistics(phylogeny);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ForesterUtil.printWarningMessage("Archaeopteryx", illegalArgumentException.getMessage());
            }
            if (list != null && list.size() > 0) {
                stringBuilder.append("\n");
                for (int i = 0; i < list.size(); ++i) {
                    DescriptiveStatistics descriptiveStatistics2 = list.get(i);
                    if (descriptiveStatistics2 == null || descriptiveStatistics2.getN() <= 1) continue;
                    if (list.size() > 1) {
                        stringBuilder.append("Support statistics " + (i + 1) + ": ");
                    } else {
                        stringBuilder.append("Support statistics: ");
                    }
                    if (!ForesterUtil.isEmpty(descriptiveStatistics2.getDescription())) {
                        stringBuilder.append("\n");
                        stringBuilder.append("    Type: " + descriptiveStatistics2.getDescription());
                    }
                    stringBuilder.append("\n");
                    stringBuilder.append("    Branches with support: " + descriptiveStatistics2.getN());
                    stringBuilder.append("\n");
                    stringBuilder.append("    Median: " + ForesterUtil.round(descriptiveStatistics2.median(), 6));
                    stringBuilder.append("\n");
                    stringBuilder.append("    Mean: " + ForesterUtil.round(descriptiveStatistics2.arithmeticMean(), 6));
                    stringBuilder.append("\n");
                    if (descriptiveStatistics2.getN() > 2) {
                        stringBuilder.append("    SD: " + ForesterUtil.round(descriptiveStatistics2.sampleStandardDeviation(), 6));
                        stringBuilder.append("\n");
                    }
                    stringBuilder.append("    Minimum: " + ForesterUtil.roundToInt(descriptiveStatistics2.getMin()));
                    stringBuilder.append("\n");
                    stringBuilder.append("    Maximum: " + ForesterUtil.roundToInt(descriptiveStatistics2.getMax()));
                    stringBuilder.append("\n");
                }
            }
        }
        return stringBuilder.toString();
    }

    static final void dieWithSystemError(String string) {
        System.out.println();
        System.out.println("Archaeopteryx encountered the following system error: " + string);
        System.out.println("Please contact the authors.");
        System.out.println("Archaeopteryx needs to close.");
        System.out.println();
        System.exit(-1);
    }

    static final String[] getAvailableFontFamiliesSorted() {
        return AVAILABLE_FONT_FAMILIES_SORTED;
    }

    static final void inferCommonPartOfScientificNames(Phylogeny phylogeny) {
        boolean bl = false;
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
        while (phylogenyNodeIterator.hasNext()) {
            String string;
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (phylogenyNode.getNodeData().isHasTaxonomy() || phylogenyNode.isExternal() || ForesterUtil.isEmpty(string = PhylogenyMethods.inferCommonPartOfScientificNameOfDescendants(phylogenyNode))) continue;
            phylogenyNode.getNodeData().setTaxonomy(new Taxonomy());
            phylogenyNode.getNodeData().getTaxonomy().setScientificName(string);
            bl = true;
        }
        if (bl) {
            phylogeny.setRerootable(false);
        }
    }

    static final boolean isHasAssignedEvent(PhylogenyNode phylogenyNode) {
        if (!phylogenyNode.getNodeData().isHasEvent()) {
            return false;
        }
        return !phylogenyNode.getNodeData().getEvent().isUnassigned();
    }

    static final boolean isJava15() {
        try {
            String string = ForesterUtil.JAVA_VERSION;
            return string.startsWith("1.5");
        }
        catch (Exception exception) {
            ForesterUtil.printWarningMessage("Archaeopteryx", "minor error: " + exception);
            return false;
        }
    }

    static final boolean isMac() {
        try {
            String string = ForesterUtil.OS_NAME.toLowerCase();
            return string.startsWith("mac");
        }
        catch (Exception exception) {
            ForesterUtil.printWarningMessage("Archaeopteryx", "minor error: " + exception);
            return false;
        }
    }

    static final boolean isUsOrCanada() {
        try {
            if (Locale.getDefault().equals(Locale.CANADA) || Locale.getDefault().equals(Locale.US)) {
                return true;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return false;
    }

    static final boolean isWindows() {
        try {
            String string = ForesterUtil.OS_NAME.toLowerCase();
            return string.indexOf("win") > -1;
        }
        catch (Exception exception) {
            ForesterUtil.printWarningMessage("Archaeopteryx", "minor error: " + exception);
            return false;
        }
    }

    public static final void launchWebBrowser(URI uRI, boolean bl, JApplet jApplet, String string) throws IOException {
        if (bl) {
            jApplet.getAppletContext().showDocument(uRI.toURL(), string);
        } else {
            try {
                AptxUtil.openUrlInWebBrowser(uRI.toString());
            }
            catch (Exception exception) {
                throw new IOException(exception);
            }
        }
    }

    static final void lookAtSomeTreePropertiesForAptxControlSettings(Phylogeny phylogeny, ControlPanel controlPanel, Configuration configuration) {
        if (phylogeny != null && !phylogeny.isEmpty()) {
            if (!AptxUtil.isHasAtLeastOneBranchLengthLargerThanZero(phylogeny)) {
                controlPanel.setDrawPhylogram(false);
                controlPanel.setDrawPhylogramEnabled(false);
            }
            if (configuration.doGuessCheckOption(0) && controlPanel.getDisplayAsPhylogramCb() != null) {
                if (AptxUtil.isHasAtLeastOneBranchLengthLargerThanZero(phylogeny)) {
                    controlPanel.setDrawPhylogram(true);
                    controlPanel.setDrawPhylogramEnabled(true);
                } else {
                    controlPanel.setDrawPhylogram(false);
                }
            }
            if (configuration.doGuessCheckOption(4) && controlPanel.getWriteConfidenceCb() != null) {
                if (AptxUtil.isHasAtLeastOneBranchWithSupportValues(phylogeny)) {
                    controlPanel.setCheckbox(4, true);
                } else {
                    controlPanel.setCheckbox(4, false);
                }
            }
            if (configuration.doGuessCheckOption(5) && controlPanel.getShowEventsCb() != null) {
                if (AptxUtil.isHasAtLeastNodeWithEvent(phylogeny)) {
                    controlPanel.setCheckbox(5, true);
                } else {
                    controlPanel.setCheckbox(5, false);
                }
            }
        }
    }

    private static final char normalizeCharForRGB(char c) {
        c = (char)(c - 65);
        c = (char)((c = (char)((double)c * 10.2)) > '\u00ff' ? 255 : (int)c);
        c = c < '\u0000' ? (char)'\u0000' : c;
        return c;
    }

    private static final void openUrlInWebBrowser(String string) throws IOException, ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, InterruptedException {
        String string2 = System.getProperty("os.name");
        Runtime runtime = Runtime.getRuntime();
        if (string2.toLowerCase().startsWith("win")) {
            Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + string);
        } else if (AptxUtil.isMac()) {
            Class<?> clazz = Class.forName("com.apple.eio.FileManager");
            Method method = clazz.getDeclaredMethod("openURL", String.class);
            method.invoke(null, string);
        } else {
            String[] stringArray = new String[]{"firefox", "opera", "konqueror", "mozilla", "netscape", "epiphany"};
            String string3 = null;
            for (int i = 0; i < stringArray.length && string3 == null; ++i) {
                if (runtime.exec(new String[]{"which", stringArray[i]}).waitFor() != 0) continue;
                string3 = stringArray[i];
            }
            if (string3 == null) {
                throw new IOException("could not find a web browser to open [" + string + "] in");
            }
            runtime.exec(new String[]{string3, string});
        }
    }

    static final void openWebsite(String string, boolean bl, JApplet jApplet) throws IOException {
        try {
            AptxUtil.launchWebBrowser(new URI(string), bl, jApplet, "Archaeopteryx");
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
    }

    static final void printAppletMessage(String string, String string2) {
        System.out.println("[" + string + "] > " + string2);
    }

    public static final void printWarningMessage(String string, String string2) {
        System.out.println("[" + string + "] > " + string2);
    }

    static final Phylogeny[] readPhylogeniesFromUrl(URL uRL, boolean bl) throws FileNotFoundException, IOException {
        PhylogenyFactory phylogenyFactory = ParserBasedPhylogenyFactory.getInstance();
        PhylogenyParser phylogenyParser = null;
        phylogenyParser = uRL.getHost().toLowerCase().indexOf("tolweb") >= 0 ? new TolParser() : ParserUtils.createParserDependingOnUrlContents(uRL, bl);
        return phylogenyFactory.create(uRL.openStream(), phylogenyParser);
    }

    static final void removeBranchColors(Phylogeny phylogeny) {
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPreorder();
        while (phylogenyNodeIterator.hasNext()) {
            phylogenyNodeIterator.next().getBranchData().setBranchColor(null);
        }
    }

    public static final void showErrorMessage(Component component, String string) {
        AptxUtil.printAppletMessage("Archaeopteryx", string);
        JOptionPane.showMessageDialog(component, string, "[Archaeopteryx 0.972 9M] Error", 0);
    }

    static final void unexpectedError(Error error) {
        error.printStackTrace();
        StringBuffer stringBuffer = new StringBuffer();
        for (StackTraceElement stackTraceElement : error.getStackTrace()) {
            stringBuffer.append(stackTraceElement + "\n");
        }
        JOptionPane.showMessageDialog(null, "An unexpected (possibly severe) error has occured - terminating. \nPlease contact: phylosoft@gmail.com \nError: " + error + "\n" + stringBuffer, "Unexpected Severe Error [Archaeopteryx 0.972 9M]", 0);
        System.exit(-1);
    }

    static final void unexpectedException(Exception exception) {
        exception.printStackTrace();
        StringBuffer stringBuffer = new StringBuffer();
        for (StackTraceElement stackTraceElement : exception.getStackTrace()) {
            stringBuffer.append(stackTraceElement + "\n");
        }
        JOptionPane.showMessageDialog(null, "An unexpected exception has occured. \nPlease contact: phylosoft@gmail.com \nException: " + exception + "\n" + stringBuffer, "Unexpected Exception [Archaeopteryx0.972 9M]", 0);
    }

    static final String writePhylogenyToGraphicsFile(String string, int n, int n2, TreePanel treePanel, ControlPanel controlPanel, GraphicsExportType graphicsExportType, Options options) throws IOException {
        if (!options.isGraphicsExportUsingActualSize()) {
            if (options.isGraphicsExportVisibleOnly()) {
                throw new IllegalArgumentException("cannot export visible rectangle only without exporting in actual size");
            }
            treePanel.setParametersForPainting(options.getPrintSizeX(), options.getPrintSizeY(), true);
            treePanel.resetPreferredSize();
            treePanel.repaint();
        }
        RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        renderingHints.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        if (options.isAntialiasPrint()) {
            renderingHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            renderingHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        Phylogeny phylogeny = treePanel.getPhylogeny();
        if (phylogeny == null || phylogeny.isEmpty()) {
            return "";
        }
        File file = new File(string);
        if (file.isDirectory()) {
            throw new IOException("\"" + string + "\" is a directory");
        }
        Rectangle rectangle = null;
        if (!options.isGraphicsExportUsingActualSize()) {
            n = options.getPrintSizeX();
            n2 = options.getPrintSizeY();
        } else if (options.isGraphicsExportVisibleOnly()) {
            rectangle = treePanel.getVisibleRect();
            n = rectangle.width;
            n2 = rectangle.height;
        }
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHints(renderingHints);
        int n3 = 0;
        int n4 = 0;
        if (options.isGraphicsExportVisibleOnly()) {
            graphics2D = (Graphics2D)graphics2D.create(-rectangle.x, -rectangle.y, rectangle.width, rectangle.height);
            graphics2D.setClip(null);
            n3 = rectangle.x;
            n4 = rectangle.y;
        }
        treePanel.paintPhylogeny(graphics2D, false, true, n, n2, n3, n4);
        if (graphicsExportType == GraphicsExportType.TIFF) {
            AptxUtil.writeToTiff(file, bufferedImage);
        } else {
            ImageIO.write((RenderedImage)bufferedImage, graphicsExportType.toString(), file);
        }
        graphics2D.dispose();
        System.gc();
        if (!options.isGraphicsExportUsingActualSize()) {
            treePanel.getMainPanel().getControlPanel().showWhole();
        }
        String string2 = file.toString();
        if (n > 0 && n2 > 0) {
            string2 = string2 + " [size: " + n + ", " + n2 + "]";
        }
        return string2;
    }

    public static final void writePhylogenyToGraphicsFileNonInteractive(File file, int n, int n2, TreePanel treePanel, ControlPanel controlPanel, GraphicsExportType graphicsExportType, Options options) throws IOException {
        treePanel.setParametersForPainting(n, n2, true);
        treePanel.resetPreferredSize();
        treePanel.repaint();
        RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        renderingHints.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        if (options.isAntialiasPrint()) {
            renderingHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            renderingHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        Phylogeny phylogeny = treePanel.getPhylogeny();
        if (phylogeny == null || phylogeny.isEmpty()) {
            return;
        }
        if (file.isDirectory()) {
            throw new IOException("\"" + file + "\" is a directory");
        }
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHints(renderingHints);
        treePanel.paintPhylogeny(graphics2D, false, true, n, n2, 0, 0);
        if (graphicsExportType == GraphicsExportType.TIFF) {
            AptxUtil.writeToTiff(file, bufferedImage);
        } else {
            ImageIO.write((RenderedImage)bufferedImage, graphicsExportType.toString(), file);
        }
        graphics2D.dispose();
    }

    static final String writePhylogenyToGraphicsByteArrayOutputStream(ByteArrayOutputStream byteArrayOutputStream, int n, int n2, TreePanel treePanel, ControlPanel controlPanel, GraphicsExportType graphicsExportType, Options options) throws IOException {
        if (!options.isGraphicsExportUsingActualSize()) {
            if (options.isGraphicsExportVisibleOnly()) {
                throw new IllegalArgumentException("cannot export visible rectangle only without exporting in actual size");
            }
            treePanel.setParametersForPainting(options.getPrintSizeX(), options.getPrintSizeY(), true);
            treePanel.resetPreferredSize();
            treePanel.repaint();
        }
        RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        renderingHints.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        if (options.isAntialiasPrint()) {
            renderingHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            renderingHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        Phylogeny phylogeny = treePanel.getPhylogeny();
        if (phylogeny == null || phylogeny.isEmpty()) {
            return "";
        }
        Rectangle rectangle = null;
        if (!options.isGraphicsExportUsingActualSize()) {
            n = options.getPrintSizeX();
            n2 = options.getPrintSizeY();
        } else if (options.isGraphicsExportVisibleOnly()) {
            rectangle = treePanel.getVisibleRect();
            n = rectangle.width;
            n2 = rectangle.height;
        }
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHints(renderingHints);
        int n3 = 0;
        int n4 = 0;
        if (options.isGraphicsExportVisibleOnly()) {
            graphics2D = (Graphics2D)graphics2D.create(-rectangle.x, -rectangle.y, rectangle.width, rectangle.height);
            graphics2D.setClip(null);
            n3 = rectangle.x;
            n4 = rectangle.y;
        }
        treePanel.paintPhylogeny(graphics2D, false, true, n, n2, n3, n4);
        ImageIO.write((RenderedImage)bufferedImage, graphicsExportType.toString(), byteArrayOutputStream);
        graphics2D.dispose();
        System.gc();
        if (!options.isGraphicsExportUsingActualSize()) {
            treePanel.getMainPanel().getControlPanel().showWhole();
        }
        String string = byteArrayOutputStream.toString();
        if (n > 0 && n2 > 0) {
            string = string + " [size: " + n + ", " + n2 + "]";
        }
        return string;
    }

    static final void writeToTiff(File file, BufferedImage bufferedImage) throws IOException {
        String[] stringArray;
        ImageWriter imageWriter = null;
        ImageOutputStream imageOutputStream = null;
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName("TIF");
        if (!iterator.hasNext()) {
            throw new IOException("failed to get TIFF image writer");
        }
        imageWriter = iterator.next();
        imageOutputStream = ImageIO.createImageOutputStream(file);
        imageWriter.setOutput(imageOutputStream);
        ImageWriteParam imageWriteParam = new ImageWriteParam(Locale.getDefault());
        imageWriteParam.setCompressionMode(2);
        imageWriteParam.setCompressionType("PackBits");
        for (String string : stringArray = imageWriteParam.getCompressionTypes()) {
            System.out.println(string);
        }
        IIOImage iIOImage = new IIOImage(bufferedImage, null, null);
        imageWriter.write(null, iIOImage, imageWriteParam);
    }

    static {
        Arrays.sort(AVAILABLE_FONT_FAMILIES_SORTED);
    }

    public static enum GraphicsExportType {
        GIF("gif"),
        JPG("jpg"),
        PDF("pdf"),
        PNG("png"),
        TIFF("tif"),
        BMP("bmp");

        private final String _suffix;

        private GraphicsExportType(String string2) {
            this._suffix = string2;
        }

        public String toString() {
            return this._suffix;
        }
    }
}

