/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JApplet;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.codec.binary.Base64;
import org.forester.archaeopteryx.AptxUtil;
import org.forester.archaeopteryx.ColorSchemeChooser;
import org.forester.archaeopteryx.Configuration;
import org.forester.archaeopteryx.FontChooser;
import org.forester.archaeopteryx.MainFrame;
import org.forester.archaeopteryx.MainPanel;
import org.forester.archaeopteryx.MainPanelApplets;
import org.forester.archaeopteryx.Options;
import org.forester.archaeopteryx.TextFrame;
import org.forester.archaeopteryx.TreeColorSet;
import org.forester.archaeopteryx.TreePanel;
import org.forester.phylogeny.Phylogeny;
import org.forester.util.ForesterConstants;
import org.forester.util.ForesterUtil;

public class ArchaeopteryxE
extends JApplet
implements ActionListener {
    private static final String NAME = "ArchaeopteryxE";
    private static final long serialVersionUID = -1220055577935759443L;
    private Configuration _configuration;
    private MainPanelApplets _main_panel;
    private JMenuBar _jmenubar;
    private JMenu _options_jmenu;
    private JMenu _font_size_menu;
    private JMenuItem _super_tiny_fonts_mi;
    private JMenuItem _tiny_fonts_mi;
    private JMenuItem _small_fonts_mi;
    private JMenuItem _medium_fonts_mi;
    private JMenuItem _large_fonts_mi;
    private TextFrame _textframe;
    private JMenu _tools_menu;
    private JMenuItem _taxcolor_item;
    private JMenuItem _confcolor_item;
    private JMenuItem _midpoint_root_item;
    private JMenu _view_jmenu;
    private JMenuItem _view_as_XML_item;
    private JMenuItem _view_as_NH_item;
    private JMenuItem _view_as_NHX_item;
    private JMenuItem _view_as_nexus_item;
    private JMenu _type_menu;
    private JCheckBoxMenuItem _rectangular_type_cbmi;
    private JCheckBoxMenuItem _triangular_type_cbmi;
    private JCheckBoxMenuItem _curved_type_cbmi;
    private JCheckBoxMenuItem _convex_type_cbmi;
    private JCheckBoxMenuItem _euro_type_cbmi;
    private JCheckBoxMenuItem _rounded_type_cbmi;
    private JCheckBoxMenuItem _unrooted_type_cbmi;
    private JCheckBoxMenuItem _circular_type_cbmi;
    private JMenuItem _help_item;
    private JMenuItem _about_item;
    private JMenu _help_jmenu;
    private JMenuItem _website_item;
    private JMenuItem _phyloxml_website_item;
    private JMenuItem _phyloxml_ref_item;
    private JMenuItem _aptx_ref_item;
    private JMenuItem _remove_branch_color_item;
    private JMenuItem _infer_common_sn_names_item;
    private JCheckBoxMenuItem _show_domain_labels;
    private JCheckBoxMenuItem _color_labels_same_as_parent_branch;
    private JCheckBoxMenuItem _abbreviate_scientific_names;
    private JCheckBoxMenuItem _screen_antialias_cbmi;
    private JCheckBoxMenuItem _background_gradient_cbmi;
    private JRadioButtonMenuItem _non_lined_up_cladograms_rbmi;
    private JRadioButtonMenuItem _uniform_cladograms_rbmi;
    private JRadioButtonMenuItem _ext_node_dependent_cladogram_rbmi;
    private Options _options;
    private JMenuItem _choose_font_mi;
    private JMenuItem _switch_colors_mi;
    JCheckBoxMenuItem _label_direction_cbmi;
    private JCheckBoxMenuItem _show_scale_cbmi;
    private JCheckBoxMenuItem _search_case_senstive_cbmi;
    private JCheckBoxMenuItem _search_whole_words_only_cbmi;
    private JCheckBoxMenuItem _inverse_search_result_cbmi;
    private JCheckBoxMenuItem _show_overview_cbmi;
    private JMenuItem _choose_minimal_confidence_mi;
    private JCheckBoxMenuItem _show_branch_length_values_cbmi;
    private JMenuItem _collapse_species_specific_subtrees;
    private JMenuItem _overview_placment_mi;
    private ButtonGroup _radio_group_1;
    private JCheckBoxMenuItem _show_default_node_shapes_cbmi;
    private JMenuItem _cycle_node_shape_mi;
    private JMenuItem _cycle_node_fill_mi;
    private JMenuItem _choose_node_size_mi;
    private JCheckBoxMenuItem _taxonomy_colorize_node_shapes_cbmi;
    private JCheckBoxMenuItem _show_confidence_stddev_cbmi;

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._midpoint_root_item) {
            this.getMainPanel().getCurrentTreePanel().midpointRoot();
        } else if (object == this._taxcolor_item) {
            this.getMainPanel().getCurrentTreePanel().taxColor();
        } else if (object == this._confcolor_item) {
            this.getMainPanel().getCurrentTreePanel().confColor();
        } else if (object == this._infer_common_sn_names_item) {
            if (this.getCurrentTreePanel() != null) {
                this.getCurrentTreePanel().inferCommonPartOfScientificNames();
            }
        } else if (object == this._collapse_species_specific_subtrees) {
            if (this.getCurrentTreePanel() != null) {
                this.getCurrentTreePanel().collapseSpeciesSpecificSubtrees();
            }
        } else if (object == this._remove_branch_color_item) {
            this.removeBranchColors();
        } else if (object == this._switch_colors_mi) {
            this.switchColors();
        } else if (object == this._view_as_NH_item) {
            this.viewAsNH();
        } else if (object == this._view_as_NHX_item) {
            this.viewAsNHX();
        } else if (object == this._view_as_XML_item) {
            this.viewAsXML();
        } else if (object == this._view_as_nexus_item) {
            this.viewAsNexus();
        } else if (object == this._super_tiny_fonts_mi) {
            if (this.getCurrentTreePanel() != null) {
                this.getCurrentTreePanel().setSuperTinyFonts();
                this.getCurrentTreePanel().repaint();
            }
        } else if (object == this._tiny_fonts_mi) {
            if (this.getCurrentTreePanel() != null) {
                this.getCurrentTreePanel().setTinyFonts();
                this.getCurrentTreePanel().repaint();
            }
        } else if (object == this._small_fonts_mi) {
            if (this.getCurrentTreePanel() != null) {
                this.getCurrentTreePanel().setSmallFonts();
                this.getCurrentTreePanel().repaint();
            }
        } else if (object == this._medium_fonts_mi) {
            if (this.getCurrentTreePanel() != null) {
                this.getCurrentTreePanel().setMediumFonts();
                this.getCurrentTreePanel().repaint();
            }
        } else if (object == this._large_fonts_mi) {
            if (this.getCurrentTreePanel() != null) {
                this.getCurrentTreePanel().setLargeFonts();
                this.getCurrentTreePanel().repaint();
            }
        } else if (object == this._choose_font_mi) {
            this.chooseFont();
        } else if (object == this._choose_minimal_confidence_mi) {
            this.chooseMinimalConfidence();
        } else if (object == this._choose_node_size_mi) {
            MainFrame.chooseNodeSize(this.getOptions(), this);
        } else if (object == this._overview_placment_mi) {
            MainFrame.cycleOverview(this.getOptions(), this.getCurrentTreePanel());
        } else if (object == this._cycle_node_fill_mi) {
            MainFrame.cycleNodeFill(this.getOptions(), this.getCurrentTreePanel());
        } else if (object == this._cycle_node_shape_mi) {
            MainFrame.cycleNodeShape(this.getOptions(), this.getCurrentTreePanel());
        } else if (object == this._non_lined_up_cladograms_rbmi) {
            this.updateOptions(this.getOptions());
            this._main_panel.getControlPanel().showWhole();
        } else if (object == this._uniform_cladograms_rbmi) {
            this.updateOptions(this.getOptions());
            this._main_panel.getControlPanel().showWhole();
        } else if (object == this._ext_node_dependent_cladogram_rbmi) {
            this.updateOptions(this.getOptions());
            this._main_panel.getControlPanel().showWhole();
        } else if (object == this._search_case_senstive_cbmi) {
            this.updateOptions(this.getOptions());
            this.getMainPanel().getControlPanel().search();
        } else if (object == this._search_whole_words_only_cbmi) {
            this.updateOptions(this.getOptions());
            this.getMainPanel().getControlPanel().search();
        } else if (object == this._inverse_search_result_cbmi) {
            this.updateOptions(this.getOptions());
            this.getMainPanel().getControlPanel().search();
        } else if (object == this._show_scale_cbmi) {
            this.updateOptions(this.getOptions());
        } else if (object == this._show_branch_length_values_cbmi) {
            this.updateOptions(this.getOptions());
        } else if (object == this._show_confidence_stddev_cbmi) {
            this.updateOptions(this.getOptions());
        } else if (object == this._label_direction_cbmi) {
            this.updateOptions(this.getOptions());
        } else if (object == this._show_overview_cbmi) {
            this.updateOptions(this.getOptions());
            if (this.getCurrentTreePanel() != null) {
                this.getCurrentTreePanel().updateOvSizes();
            }
        } else if (object == this._rectangular_type_cbmi || object == this._triangular_type_cbmi || object == this._curved_type_cbmi || object == this._convex_type_cbmi || object == this._rounded_type_cbmi || object == this._euro_type_cbmi || object == this._unrooted_type_cbmi || object == this._circular_type_cbmi) {
            this.typeChanged(object);
        } else if (object == this._screen_antialias_cbmi) {
            this.updateOptions(this.getOptions());
            ArchaeopteryxE.setupScreenTextAntialias(this.getMainPanel().getTreePanels(), this.isScreenAntialias());
        } else if (object == this._background_gradient_cbmi) {
            this.updateOptions(this.getOptions());
        } else if (object == this._show_domain_labels) {
            this.updateOptions(this.getOptions());
        } else if (object == this._color_labels_same_as_parent_branch) {
            this.updateOptions(this.getOptions());
        } else if (object == this._show_default_node_shapes_cbmi) {
            this.updateOptions(this.getOptions());
        } else if (object == this._taxonomy_colorize_node_shapes_cbmi) {
            this.updateOptions(this.getOptions());
        } else if (object == this._about_item) {
            MainFrame.about();
        } else if (object == this._help_item) {
            MainFrame.help(this.getConfiguration().getWebLinks());
        } else if (object == this._website_item) {
            try {
                AptxUtil.openWebsite("http://www.phylosoft.org/archaeopteryx/", true, this);
            }
            catch (IOException iOException) {
                ForesterUtil.printErrorMessage("Archaeopteryx", iOException.toString());
            }
        } else if (object == this._phyloxml_website_item) {
            try {
                AptxUtil.openWebsite("http://www.phyloxml.org", true, this);
            }
            catch (IOException iOException) {
                ForesterUtil.printErrorMessage("Archaeopteryx", iOException.toString());
            }
        } else if (object == this._aptx_ref_item) {
            try {
                AptxUtil.openWebsite("http://www.biomedcentral.com/bmcbioinformatics/", true, this);
            }
            catch (IOException iOException) {
                ForesterUtil.printErrorMessage("Archaeopteryx", iOException.toString());
            }
        } else if (object == this._phyloxml_ref_item) {
            try {
                AptxUtil.openWebsite("http://www.biomedcentral.com/1471-2105/10/356/", true, this);
            }
            catch (IOException iOException) {
                ForesterUtil.printErrorMessage("Archaeopteryx", iOException.toString());
            }
        }
        this.repaint();
    }

    public String getCurrentPhylogeny(String string) {
        this.removeTextFrame();
        if (this.getMainPanel().getCurrentPhylogeny() == null || this.getMainPanel().getCurrentPhylogeny().isEmpty() || this.getMainPanel().getCurrentPhylogeny().getNumberOfExternalNodes() > 10000) {
            return new String();
        }
        switch (ForesterConstants.PhylogeneticTreeFormats.valueOf(string)) {
            case NH: {
                return this.getMainPanel().getCurrentPhylogeny().toNewHampshire();
            }
            case NHX: {
                return this.getMainPanel().getCurrentPhylogeny().toNewHampshireX();
            }
            case NEXUS: {
                return this.getMainPanel().getCurrentPhylogeny().toNexus();
            }
            case PHYLOXML: {
                return this.getMainPanel().getCurrentPhylogeny().toPhyloXML(-1);
            }
        }
        return new String();
    }

    public String getCurrentPhylogenyGraphicsAsBase64EncodedString(String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            AptxUtil.writePhylogenyToGraphicsByteArrayOutputStream(byteArrayOutputStream, this._main_panel.getWidth(), this._main_panel.getHeight(), this.getCurrentTreePanel(), this.getCurrentTreePanel().getControlPanel(), AptxUtil.GraphicsExportType.valueOf(string), this.getOptions());
        }
        catch (IOException iOException) {
            ForesterUtil.printErrorMessage(NAME, iOException.toString());
            iOException.printStackTrace();
            JOptionPane.showMessageDialog(this, "ArchaeopteryxE: Failed to generate graphics: \nException: " + iOException, "Failed to generate graphics", 0);
            return null;
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        String string2 = Base64.encodeBase64String(byArray);
        return string2;
    }

    void buildFontSizeMenu() {
        this._font_size_menu = MainFrame.createMenu("Font Size", this.getConfiguration());
        this._super_tiny_fonts_mi = new JMenuItem("Super tiny fonts");
        this._font_size_menu.add(this._super_tiny_fonts_mi);
        this._tiny_fonts_mi = new JMenuItem("Tiny fonts");
        this._font_size_menu.add(this._tiny_fonts_mi);
        this._small_fonts_mi = new JMenuItem("Small fonts");
        this._font_size_menu.add(this._small_fonts_mi);
        this._medium_fonts_mi = new JMenuItem("Medium fonts");
        this._font_size_menu.add(this._medium_fonts_mi);
        this._large_fonts_mi = new JMenuItem("Large fonts");
        this._font_size_menu.add(this._large_fonts_mi);
        this.customizeJMenuItem(this._super_tiny_fonts_mi);
        this.customizeJMenuItem(this._tiny_fonts_mi);
        this.customizeJMenuItem(this._small_fonts_mi);
        this.customizeJMenuItem(this._medium_fonts_mi);
        this.customizeJMenuItem(this._large_fonts_mi);
        this._jmenubar.add(this._font_size_menu);
    }

    void buildHelpMenu() {
        this._help_jmenu = MainFrame.createMenu("Help", this.getConfiguration());
        this._help_item = new JMenuItem("Help");
        this._help_jmenu.add(this._help_item);
        this._website_item = new JMenuItem("Archaeopteryx Home");
        this._help_jmenu.add(this._website_item);
        this._aptx_ref_item = new JMenuItem("Archaeopteryx Reference");
        this._phyloxml_website_item = new JMenuItem("phyloXML Home");
        this._help_jmenu.add(this._phyloxml_website_item);
        this._phyloxml_ref_item = new JMenuItem("phyloXML Reference");
        this._help_jmenu.add(this._phyloxml_ref_item);
        this._help_jmenu.addSeparator();
        this._about_item = new JMenuItem("About");
        this._help_jmenu.add(this._about_item);
        this.customizeJMenuItem(this._help_item);
        this.customizeJMenuItem(this._website_item);
        this.customizeJMenuItem(this._phyloxml_website_item);
        this.customizeJMenuItem(this._aptx_ref_item);
        this.customizeJMenuItem(this._phyloxml_ref_item);
        this.customizeJMenuItem(this._about_item);
        this._phyloxml_ref_item.setToolTipText("Han MV and Zmasek CM (2009): \"phyloXML: XML for evolutionary biology and comparative genomics\", BMC Bioinformatics 10:356");
        this._aptx_ref_item.setToolTipText("Zmasek...");
        this._jmenubar.add(this._help_jmenu);
    }

    void buildOptionsMenu() {
        this._options_jmenu = MainFrame.createMenu("Options", this.getConfiguration());
        this._options_jmenu.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                MainFrame.setOvPlacementColorChooseMenuItem(ArchaeopteryxE.this._overview_placment_mi, ArchaeopteryxE.this.getOptions());
                MainFrame.setTextColorChooseMenuItem(ArchaeopteryxE.this._switch_colors_mi, ArchaeopteryxE.this.getCurrentTreePanel());
                MainFrame.setTextMinSupportMenuItem(ArchaeopteryxE.this._choose_minimal_confidence_mi, ArchaeopteryxE.this.getOptions(), ArchaeopteryxE.this.getCurrentTreePanel());
                MainFrame.setTextForFontChooserMenuItem(ArchaeopteryxE.this._choose_font_mi, MainFrame.createCurrentFontDesc(ArchaeopteryxE.this.getMainPanel().getTreeFontSet()));
                MainFrame.updateOptionsMenuDependingOnPhylogenyType(ArchaeopteryxE.this.getMainPanel(), ArchaeopteryxE.this._show_scale_cbmi, ArchaeopteryxE.this._show_branch_length_values_cbmi, ArchaeopteryxE.this._non_lined_up_cladograms_rbmi, ArchaeopteryxE.this._uniform_cladograms_rbmi, ArchaeopteryxE.this._ext_node_dependent_cladogram_rbmi, ArchaeopteryxE.this._label_direction_cbmi);
                MainFrame.setCycleNodeFillMenuItem(ArchaeopteryxE.this._cycle_node_fill_mi, ArchaeopteryxE.this.getOptions());
                MainFrame.setCycleNodeShapeMenuItem(ArchaeopteryxE.this._cycle_node_shape_mi, ArchaeopteryxE.this.getOptions());
                MainFrame.setTextNodeSizeMenuItem(ArchaeopteryxE.this._choose_node_size_mi, ArchaeopteryxE.this.getOptions());
            }
        });
        this._options_jmenu.add(MainFrame.customizeMenuItemAsLabel(new JMenuItem("Display:"), this.getConfiguration()));
        this._ext_node_dependent_cladogram_rbmi = new JRadioButtonMenuItem("External Node Sum Dependent Cladograms");
        this._options_jmenu.add(this._ext_node_dependent_cladogram_rbmi);
        this._uniform_cladograms_rbmi = new JRadioButtonMenuItem("Total Node Sum Dependent Cladograms");
        this._options_jmenu.add(this._uniform_cladograms_rbmi);
        this._non_lined_up_cladograms_rbmi = new JRadioButtonMenuItem("Non-Lined Up Cladograms");
        this._options_jmenu.add(this._non_lined_up_cladograms_rbmi);
        this._radio_group_1 = new ButtonGroup();
        this._radio_group_1.add(this._ext_node_dependent_cladogram_rbmi);
        this._radio_group_1.add(this._uniform_cladograms_rbmi);
        this._radio_group_1.add(this._non_lined_up_cladograms_rbmi);
        this._show_overview_cbmi = new JCheckBoxMenuItem("Show Overview");
        this._options_jmenu.add(this._show_overview_cbmi);
        this._show_scale_cbmi = new JCheckBoxMenuItem("Display Scale");
        this._options_jmenu.add(this._show_scale_cbmi);
        this._show_branch_length_values_cbmi = new JCheckBoxMenuItem("Display Branch Length Values");
        this._options_jmenu.add(this._show_branch_length_values_cbmi);
        this._show_confidence_stddev_cbmi = new JCheckBoxMenuItem("Show Confidence Standard Deviations");
        this._options_jmenu.add(this._show_confidence_stddev_cbmi);
        this._show_default_node_shapes_cbmi = new JCheckBoxMenuItem("Show Node Shapes");
        this._options_jmenu.add(this._show_default_node_shapes_cbmi);
        this._taxonomy_colorize_node_shapes_cbmi = new JCheckBoxMenuItem("Colorize Node Shapes According to Taxonomy");
        this._options_jmenu.add(this._taxonomy_colorize_node_shapes_cbmi);
        this._cycle_node_shape_mi = new JMenuItem("Cycle Node Shapes");
        this._options_jmenu.add(this._cycle_node_shape_mi);
        this._cycle_node_fill_mi = new JMenuItem("Cycle Node Fill Type");
        this._options_jmenu.add(this._cycle_node_fill_mi);
        this._choose_node_size_mi = new JMenuItem("Choose Node Shape Size");
        this._options_jmenu.add(this._choose_node_size_mi);
        this._label_direction_cbmi = new JCheckBoxMenuItem("Radial Labels");
        this._options_jmenu.add(this._label_direction_cbmi);
        this._color_labels_same_as_parent_branch = new JCheckBoxMenuItem("Colorize Labels Same as Parent Branch");
        this._options_jmenu.add(this._color_labels_same_as_parent_branch);
        this._color_labels_same_as_parent_branch.setToolTipText("To use parent branch colors for node labels as well, need to turn off taxonomy dependent colorization and turn on branch colorization for this to become apparent");
        this._abbreviate_scientific_names = new JCheckBoxMenuItem("Abbreviate Scientific Taxonomic Names");
        this._options_jmenu.add(this._abbreviate_scientific_names);
        this._label_direction_cbmi.setToolTipText("To use radial node labels in radial and unrooted display types");
        this._screen_antialias_cbmi = new JCheckBoxMenuItem("Antialias");
        this._options_jmenu.add(this._screen_antialias_cbmi);
        this._background_gradient_cbmi = new JCheckBoxMenuItem("Background Color Gradient");
        this._options_jmenu.add(this._background_gradient_cbmi);
        if (this.getConfiguration().doDisplayOption(10)) {
            this._show_domain_labels = new JCheckBoxMenuItem("Show Domain Labels");
            this._options_jmenu.add(this._show_domain_labels);
        }
        this._choose_minimal_confidence_mi = new JMenuItem("");
        this._options_jmenu.add(this._choose_minimal_confidence_mi);
        this._overview_placment_mi = new JMenuItem("");
        this._options_jmenu.add(this._overview_placment_mi);
        this._switch_colors_mi = new JMenuItem("");
        this._options_jmenu.add(this._switch_colors_mi);
        this._choose_font_mi = new JMenuItem("");
        this._options_jmenu.add(this._choose_font_mi);
        this._options_jmenu.addSeparator();
        this._options_jmenu.add(MainFrame.customizeMenuItemAsLabel(new JMenuItem("Search:"), this.getConfiguration()));
        this._search_case_senstive_cbmi = new JCheckBoxMenuItem("Case Sensitive");
        this._options_jmenu.add(this._search_case_senstive_cbmi);
        this._search_whole_words_only_cbmi = new JCheckBoxMenuItem("Match Complete Terms Only");
        this._options_jmenu.add(this._search_whole_words_only_cbmi);
        this._inverse_search_result_cbmi = new JCheckBoxMenuItem("Negate Result");
        this._options_jmenu.add(this._inverse_search_result_cbmi);
        this.customizeJMenuItem(this._choose_font_mi);
        this.customizeJMenuItem(this._choose_minimal_confidence_mi);
        this.customizeJMenuItem(this._switch_colors_mi);
        this.customizeJMenuItem(this._overview_placment_mi);
        this.customizeCheckBoxMenuItem(this._label_direction_cbmi, this.getOptions().getNodeLabelDirection() == Options.NODE_LABEL_DIRECTION.RADIAL);
        this.customizeCheckBoxMenuItem(this._screen_antialias_cbmi, this.getOptions().isAntialiasScreen());
        this.customizeCheckBoxMenuItem(this._background_gradient_cbmi, this.getOptions().isBackgroundColorGradient());
        this.customizeCheckBoxMenuItem(this._show_domain_labels, this.getOptions().isShowDomainLabels());
        this.customizeCheckBoxMenuItem(this._abbreviate_scientific_names, this.getOptions().isAbbreviateScientificTaxonNames());
        this.customizeCheckBoxMenuItem(this._show_default_node_shapes_cbmi, this.getOptions().isShowDefaultNodeShapes());
        this.customizeCheckBoxMenuItem(this._taxonomy_colorize_node_shapes_cbmi, this.getOptions().isTaxonomyColorizeNodeShapes());
        this.customizeJMenuItem(this._cycle_node_shape_mi);
        this.customizeJMenuItem(this._cycle_node_fill_mi);
        this.customizeJMenuItem(this._choose_node_size_mi);
        this.customizeCheckBoxMenuItem(this._color_labels_same_as_parent_branch, this.getOptions().isColorLabelsSameAsParentBranch());
        this.customizeCheckBoxMenuItem(this._search_case_senstive_cbmi, this.getOptions().isSearchCaseSensitive());
        this.customizeCheckBoxMenuItem(this._show_scale_cbmi, this.getOptions().isShowScale());
        this.customizeRadioButtonMenuItem(this._non_lined_up_cladograms_rbmi, this.getOptions().getCladogramType() == Options.CLADOGRAM_TYPE.NON_LINED_UP);
        this.customizeRadioButtonMenuItem(this._uniform_cladograms_rbmi, this.getOptions().getCladogramType() == Options.CLADOGRAM_TYPE.TOTAL_NODE_SUM_DEP);
        this.customizeRadioButtonMenuItem(this._ext_node_dependent_cladogram_rbmi, this.getOptions().getCladogramType() == Options.CLADOGRAM_TYPE.EXT_NODE_SUM_DEP);
        this.customizeCheckBoxMenuItem(this._show_branch_length_values_cbmi, this.getOptions().isShowBranchLengthValues());
        this.customizeCheckBoxMenuItem(this._show_overview_cbmi, this.getOptions().isShowOverview());
        this.customizeCheckBoxMenuItem(this._search_whole_words_only_cbmi, this.getOptions().isMatchWholeTermsOnly());
        this.customizeCheckBoxMenuItem(this._inverse_search_result_cbmi, this.getOptions().isInverseSearchResult());
        this.customizeCheckBoxMenuItem(this._show_confidence_stddev_cbmi, this.getOptions().isShowConfidenceStddev());
        this._jmenubar.add(this._options_jmenu);
    }

    void buildToolsMenu() {
        this._tools_menu = MainFrame.createMenu("Tools", this.getConfiguration());
        this._confcolor_item = new JMenuItem("Colorize Branches Depending on Confidence");
        this._tools_menu.add(this._confcolor_item);
        this.customizeJMenuItem(this._confcolor_item);
        this._taxcolor_item = new JMenuItem("Taxonomy Colorize Branches");
        this._tools_menu.add(this._taxcolor_item);
        this.customizeJMenuItem(this._taxcolor_item);
        this._remove_branch_color_item = new JMenuItem("Delete Branch Colors");
        this._tools_menu.add(this._remove_branch_color_item);
        this._remove_branch_color_item.setToolTipText("To delete branch color values from the current phylogeny.");
        this.customizeJMenuItem(this._remove_branch_color_item);
        this._tools_menu.addSeparator();
        this._midpoint_root_item = new JMenuItem("Midpoint-Root");
        this._tools_menu.add(this._midpoint_root_item);
        this.customizeJMenuItem(this._midpoint_root_item);
        this._tools_menu.addSeparator();
        this._infer_common_sn_names_item = new JMenuItem("Infer Common Parts of Internal Scientific Names");
        this._tools_menu.add(this._infer_common_sn_names_item);
        this.customizeJMenuItem(this._infer_common_sn_names_item);
        this._collapse_species_specific_subtrees = new JMenuItem("Collapse Species-Specific Subtrees");
        this._tools_menu.add(this._collapse_species_specific_subtrees);
        this.customizeJMenuItem(this._collapse_species_specific_subtrees);
        this._jmenubar.add(this._tools_menu);
    }

    void buildTypeMenu() {
        this._type_menu = MainFrame.createMenu("Type", this.getConfiguration());
        this._rectangular_type_cbmi = new JCheckBoxMenuItem("Rectangular");
        this._type_menu.add(this._rectangular_type_cbmi);
        this._euro_type_cbmi = new JCheckBoxMenuItem("Euro Type");
        this._type_menu.add(this._euro_type_cbmi);
        this._rounded_type_cbmi = new JCheckBoxMenuItem("Rounded");
        this._type_menu.add(this._rounded_type_cbmi);
        this._curved_type_cbmi = new JCheckBoxMenuItem("Curved");
        this._type_menu.add(this._curved_type_cbmi);
        this._triangular_type_cbmi = new JCheckBoxMenuItem("Triangular");
        this._type_menu.add(this._triangular_type_cbmi);
        this._convex_type_cbmi = new JCheckBoxMenuItem("Convex");
        this._type_menu.add(this._convex_type_cbmi);
        this._unrooted_type_cbmi = new JCheckBoxMenuItem("Unrooted (alpha)");
        this._type_menu.add(this._unrooted_type_cbmi);
        this._circular_type_cbmi = new JCheckBoxMenuItem("Circular (alpha)");
        this._type_menu.add(this._circular_type_cbmi);
        this.customizeCheckBoxMenuItem(this._rectangular_type_cbmi, false);
        this.customizeCheckBoxMenuItem(this._triangular_type_cbmi, false);
        this.customizeCheckBoxMenuItem(this._euro_type_cbmi, false);
        this.customizeCheckBoxMenuItem(this._rounded_type_cbmi, false);
        this.customizeCheckBoxMenuItem(this._curved_type_cbmi, false);
        this.customizeCheckBoxMenuItem(this._convex_type_cbmi, false);
        this.customizeCheckBoxMenuItem(this._unrooted_type_cbmi, false);
        this.customizeCheckBoxMenuItem(this._circular_type_cbmi, false);
        this._unrooted_type_cbmi.setToolTipText("In this display type, use mousewheel + Shift to rotate [or A and S]");
        this._circular_type_cbmi.setToolTipText("In this display type, use mousewheel + Shift to rotate [or A and S]");
        this.initializeTypeMenu(this.getOptions());
        this._jmenubar.add(this._type_menu);
    }

    void buildViewMenu() {
        this._view_jmenu = MainFrame.createMenu("View as Text", this.getConfiguration());
        this._view_as_XML_item = new JMenuItem("View as phyloXML");
        this._view_jmenu.add(this._view_as_XML_item);
        this._view_as_NH_item = new JMenuItem("View as Newick");
        this._view_jmenu.add(this._view_as_NH_item);
        this._view_as_NHX_item = new JMenuItem("View as NHX");
        this._view_jmenu.add(this._view_as_NHX_item);
        this._view_as_nexus_item = new JMenuItem("View as Nexus");
        this._view_jmenu.add(this._view_as_nexus_item);
        this.customizeJMenuItem(this._view_as_NH_item);
        this.customizeJMenuItem(this._view_as_NHX_item);
        this.customizeJMenuItem(this._view_as_XML_item);
        this.customizeJMenuItem(this._view_as_nexus_item);
        this._jmenubar.add(this._view_jmenu);
    }

    private void chooseFont() {
        FontChooser fontChooser = new FontChooser();
        fontChooser.setFont(this.getMainPanel().getTreeFontSet().getLargeFont());
        fontChooser.showDialog(this, "Select the Base Font");
        this.getMainPanel().getTreeFontSet().setBaseFont(fontChooser.getFont());
    }

    private void chooseMinimalConfidence() {
        String string = (String)JOptionPane.showInputDialog(this, "Please the minimum for confidence values to be displayed.\n[current value: " + this.getOptions().getMinConfidenceValue() + "]\n", "Minimal Confidence Value", 3, null, null, this.getOptions().getMinConfidenceValue());
        if (!ForesterUtil.isEmpty(string)) {
            boolean bl = true;
            double d = 0.0;
            String string2 = string.trim();
            if (!ForesterUtil.isEmpty(string2)) {
                try {
                    d = Double.parseDouble(string2);
                }
                catch (Exception exception) {
                    bl = false;
                }
            } else {
                bl = false;
            }
            if (bl && d >= 0.0) {
                this.getOptions().setMinConfidenceValue(d);
            }
        }
    }

    void customizeCheckBoxMenuItem(JCheckBoxMenuItem jCheckBoxMenuItem, boolean bl) {
        if (jCheckBoxMenuItem != null) {
            jCheckBoxMenuItem.setFont(MainFrame.menu_font);
            if (!this.getConfiguration().isUseNativeUI()) {
                jCheckBoxMenuItem.setBackground(this.getConfiguration().getGuiMenuBackgroundColor());
                jCheckBoxMenuItem.setForeground(this.getConfiguration().getGuiMenuTextColor());
            }
            jCheckBoxMenuItem.setSelected(bl);
            jCheckBoxMenuItem.addActionListener(this);
        }
    }

    void customizeJMenuItem(JMenuItem jMenuItem) {
        jMenuItem.setFont(MainFrame.menu_font);
        if (!this.getConfiguration().isUseNativeUI()) {
            jMenuItem.setBackground(this.getConfiguration().getGuiMenuBackgroundColor());
            jMenuItem.setForeground(this.getConfiguration().getGuiMenuTextColor());
        }
        jMenuItem.addActionListener(this);
    }

    private void customizeRadioButtonMenuItem(JRadioButtonMenuItem jRadioButtonMenuItem, boolean bl) {
        if (jRadioButtonMenuItem != null) {
            jRadioButtonMenuItem.setFont(MainFrame.menu_font);
            if (!this.getConfiguration().isUseNativeUI()) {
                jRadioButtonMenuItem.setBackground(this.getConfiguration().getGuiMenuBackgroundColor());
                jRadioButtonMenuItem.setForeground(this.getConfiguration().getGuiMenuTextColor());
            }
            jRadioButtonMenuItem.setSelected(bl);
            jRadioButtonMenuItem.addActionListener(this);
        }
    }

    @Override
    public void destroy() {
        AptxUtil.printAppletMessage(NAME, "going to be destroyed ");
        this.removeTextFrame();
        if (this.getMainPanel() != null) {
            this.getMainPanel().terminate();
        }
    }

    Configuration getConfiguration() {
        return this._configuration;
    }

    TreePanel getCurrentTreePanel() {
        return this.getMainPanel().getCurrentTreePanel();
    }

    JCheckBoxMenuItem getlabelDirectionCbmi() {
        return this._label_direction_cbmi;
    }

    private MainPanel getMainPanel() {
        return this._main_panel;
    }

    public Options getOptions() {
        return this._options;
    }

    Options getOtions() {
        return this._options;
    }

    @Override
    public void init() {
        Object object2;
        String string = this.getParameter("config_file");
        AptxUtil.printAppletMessage(NAME, "URL for configuration file is: " + string);
        Configuration configuration = new Configuration(string, true, true, true);
        this.setConfiguration(configuration);
        this.setOptions(Options.createInstance(configuration));
        this.setupUI();
        URL uRL = null;
        Phylogeny[] phylogenyArray = null;
        String string2 = this.getParameter("url_of_tree_to_load");
        AptxUtil.printAppletMessage(NAME, "URL for phylogenies is " + string2);
        if (string2 != null) {
            try {
                uRL = new URL(string2);
            }
            catch (Exception exception) {
                ForesterUtil.printErrorMessage(NAME, "error: " + exception);
                exception.printStackTrace();
                JOptionPane.showMessageDialog(this, "ArchaeopteryxE: Could not create URL from: \"" + string2 + "\"\nException: " + exception, "Failed to create URL", 0);
            }
        }
        if (uRL != null) {
            try {
                phylogenyArray = AptxUtil.readPhylogeniesFromUrl(uRL, this.getConfiguration().isValidatePhyloXmlAgainstSchema());
            }
            catch (Exception exception) {
                ForesterUtil.printErrorMessage(NAME, exception.toString());
                exception.printStackTrace();
                JOptionPane.showMessageDialog(this, "ArchaeopteryxE: Failed to read phylogenies: \nException: " + exception, "Failed to read phylogenies", 0);
            }
        }
        if (phylogenyArray == null || phylogenyArray.length < 1) {
            ForesterUtil.printErrorMessage(NAME, "phylogenies from [" + uRL + "] are null or empty");
            JOptionPane.showMessageDialog(this, "ArchaeopteryxE: phylogenies from [" + uRL + "] are null or empty", "Failed to read phylogenies", 0);
            return;
        }
        AptxUtil.printAppletMessage(NAME, "loaded " + phylogenyArray.length + " phylogenies from: " + uRL);
        this.setVisible(false);
        this.setMainPanel(new MainPanelApplets(this.getConfiguration(), this));
        this._jmenubar = new JMenuBar();
        if (!this.getConfiguration().isHideControlPanelAndMenubar()) {
            if (!this.getConfiguration().isUseNativeUI()) {
                this._jmenubar.setBackground(this.getConfiguration().getGuiMenuBackgroundColor());
            }
            this.buildToolsMenu();
            this.buildViewMenu();
            this.buildFontSizeMenu();
            this.buildOptionsMenu();
            this.buildTypeMenu();
            this.buildHelpMenu();
            this.setJMenuBar(this._jmenubar);
        }
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.getMainPanel(), "Center");
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                if (ArchaeopteryxE.this.getMainPanel().getCurrentTreePanel() != null) {
                    ArchaeopteryxE.this.getMainPanel().getCurrentTreePanel().setParametersForPainting(ArchaeopteryxE.this.getMainPanel().getCurrentTreePanel().getWidth(), ArchaeopteryxE.this.getMainPanel().getCurrentTreePanel().getHeight(), false);
                }
            }
        });
        if (this.getConfiguration().isUseTabbedDisplay()) {
            AptxUtil.printAppletMessage(NAME, "using tabbed display");
            AptxUtil.addPhylogeniesToTabs(phylogenyArray, new File(uRL.getFile()).getName(), uRL.toString(), this.getConfiguration(), this.getMainPanel());
        } else {
            AptxUtil.printAppletMessage(NAME, "not using tabbed display");
            AptxUtil.addPhylogenyToPanel(phylogenyArray, this.getConfiguration(), this.getMainPanel());
        }
        this.validate();
        this.setName(NAME);
        this.getMainPanel().getControlPanel().showWholeAll();
        this.getMainPanel().getControlPanel().showWhole();
        System.gc();
        AptxUtil.printAppletMessage(NAME, "successfully initialized");
        this.getCurrentTreePanel().getControlPanel().getSequenceRelationTypeBox().removeAllItems();
        for (Object object2 : this.getMainPanel().getCurrentPhylogeny().getRelevantSequenceRelationTypes()) {
            this.getCurrentTreePanel().getControlPanel().getSequenceRelationTypeBox().addItem(object2);
        }
        String string3 = this.getParameter("homology_type_analysis_initial_relation_type");
        if (string3 != null) {
            this.getCurrentTreePanel().getControlPanel().getSequenceRelationTypeBox().setSelectedItem(string3);
        }
        if ((object2 = this.getParameter("homology_type_analysis_query_sequence")) != null) {
            this.getCurrentTreePanel().getControlPanel().getSequenceRelationBox().setSelectedItem(object2);
        }
        this.setVisible(true);
    }

    void initializeTypeMenu(Options options) {
        this.setTypeMenuToAllUnselected();
        try {
            switch (options.getPhylogenyGraphicsType()) {
                case CONVEX: {
                    this._convex_type_cbmi.setSelected(true);
                    break;
                }
                case CURVED: {
                    this._curved_type_cbmi.setSelected(true);
                    break;
                }
                case EURO_STYLE: {
                    this._euro_type_cbmi.setSelected(true);
                    break;
                }
                case ROUNDED: {
                    this._rounded_type_cbmi.setSelected(true);
                    break;
                }
                case TRIANGULAR: {
                    this._triangular_type_cbmi.setSelected(true);
                    break;
                }
                case UNROOTED: {
                    this._unrooted_type_cbmi.setSelected(true);
                    break;
                }
                case CIRCULAR: {
                    this._circular_type_cbmi.setSelected(true);
                    break;
                }
                default: {
                    this._rectangular_type_cbmi.setSelected(true);
                    break;
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private boolean isScreenAntialias() {
        return true;
    }

    private void removeBranchColors() {
        if (this.getMainPanel().getCurrentPhylogeny() != null) {
            AptxUtil.removeBranchColors(this.getMainPanel().getCurrentPhylogeny());
        }
    }

    void removeTextFrame() {
        if (this._textframe != null) {
            this._textframe.close();
            this._textframe = null;
        }
    }

    void setConfiguration(Configuration configuration) {
        this._configuration = configuration;
    }

    private void setMainPanel(MainPanelApplets mainPanelApplets) {
        this._main_panel = mainPanelApplets;
    }

    void setOptions(Options options) {
        this._options = options;
    }

    void setSelectedTypeInTypeMenu(Options.PHYLOGENY_GRAPHICS_TYPE pHYLOGENY_GRAPHICS_TYPE) {
        this.setTypeMenuToAllUnselected();
        try {
            switch (pHYLOGENY_GRAPHICS_TYPE) {
                case CIRCULAR: {
                    this._circular_type_cbmi.setSelected(true);
                    break;
                }
                case CONVEX: {
                    this._convex_type_cbmi.setSelected(true);
                    break;
                }
                case CURVED: {
                    this._curved_type_cbmi.setSelected(true);
                    break;
                }
                case EURO_STYLE: {
                    this._euro_type_cbmi.setSelected(true);
                    break;
                }
                case ROUNDED: {
                    this._rounded_type_cbmi.setSelected(true);
                    break;
                }
                case RECTANGULAR: {
                    this._rectangular_type_cbmi.setSelected(true);
                    break;
                }
                case TRIANGULAR: {
                    this._triangular_type_cbmi.setSelected(true);
                    break;
                }
                case UNROOTED: {
                    this._unrooted_type_cbmi.setSelected(true);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown type: " + (Object)((Object)pHYLOGENY_GRAPHICS_TYPE));
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    void setTypeMenuToAllUnselected() {
        if (this._convex_type_cbmi != null) {
            this._convex_type_cbmi.setSelected(false);
        }
        if (this._curved_type_cbmi != null) {
            this._curved_type_cbmi.setSelected(false);
        }
        if (this._euro_type_cbmi != null) {
            this._euro_type_cbmi.setSelected(false);
        }
        if (this._rounded_type_cbmi != null) {
            this._rounded_type_cbmi.setSelected(false);
        }
        if (this._triangular_type_cbmi != null) {
            this._triangular_type_cbmi.setSelected(false);
        }
        if (this._rectangular_type_cbmi != null) {
            this._rectangular_type_cbmi.setSelected(false);
        }
        if (this._unrooted_type_cbmi != null) {
            this._unrooted_type_cbmi.setSelected(false);
        }
        if (this._circular_type_cbmi != null) {
            this._circular_type_cbmi.setSelected(false);
        }
    }

    private void setupUI() {
        try {
            if (this.getConfiguration().isUseNativeUI()) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            } else {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            AptxUtil.dieWithSystemError("UnsupportedLookAndFeelException: " + unsupportedLookAndFeelException.toString());
        }
        catch (ClassNotFoundException classNotFoundException) {
            AptxUtil.dieWithSystemError("ClassNotFoundException: " + classNotFoundException.toString());
        }
        catch (InstantiationException instantiationException) {
            AptxUtil.dieWithSystemError("InstantiationException: " + instantiationException.toString());
        }
        catch (IllegalAccessException illegalAccessException) {
            AptxUtil.dieWithSystemError("IllegalAccessException: " + illegalAccessException.toString());
        }
        catch (Exception exception) {
            AptxUtil.dieWithSystemError(exception.toString());
        }
    }

    @Override
    public void start() {
        if (this.getMainPanel() != null) {
            this.getMainPanel().validate();
        }
        this.requestFocus();
        this.requestFocusInWindow();
        this.requestFocus();
        AptxUtil.printAppletMessage(NAME, "started");
    }

    void switchColors() {
        TreeColorSet treeColorSet = this.getMainPanel().getCurrentTreePanel().getTreeColorSet();
        ColorSchemeChooser colorSchemeChooser = new ColorSchemeChooser(this.getMainPanel(), treeColorSet);
        colorSchemeChooser.setVisible(true);
        this.getMainPanel().setTreeColorSet(treeColorSet);
    }

    void typeChanged(Object object) {
        this.updateTypeCheckboxes(this.getOptions(), object);
        this.updateOptions(this.getOptions());
        if (this.getCurrentTreePanel() != null) {
            Options.PHYLOGENY_GRAPHICS_TYPE pHYLOGENY_GRAPHICS_TYPE = this.getCurrentTreePanel().getPhylogenyGraphicsType();
            Options.PHYLOGENY_GRAPHICS_TYPE pHYLOGENY_GRAPHICS_TYPE2 = this.getOptions().getPhylogenyGraphicsType();
            if (pHYLOGENY_GRAPHICS_TYPE == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED && pHYLOGENY_GRAPHICS_TYPE2 != Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED || pHYLOGENY_GRAPHICS_TYPE == Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR && pHYLOGENY_GRAPHICS_TYPE2 != Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR || pHYLOGENY_GRAPHICS_TYPE != Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED && pHYLOGENY_GRAPHICS_TYPE2 == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED || pHYLOGENY_GRAPHICS_TYPE != Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR && pHYLOGENY_GRAPHICS_TYPE2 == Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR) {
                this.getCurrentTreePanel().getControlPanel().showWhole();
            }
            if (this.getCurrentTreePanel().isPhyHasBranchLengths() && pHYLOGENY_GRAPHICS_TYPE2 != Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR) {
                this.getCurrentTreePanel().getControlPanel().setDrawPhylogramEnabled(true);
            } else {
                this.getCurrentTreePanel().getControlPanel().setDrawPhylogramEnabled(false);
            }
            this.getCurrentTreePanel().setPhylogenyGraphicsType(this.getOptions().getPhylogenyGraphicsType());
            MainFrame.updateScreenTextAntialias(this.getMainPanel().getTreePanels());
        }
    }

    void updateOptions(Options options) {
        options.setAntialiasScreen(this._screen_antialias_cbmi != null && this._screen_antialias_cbmi.isSelected());
        options.setBackgroundColorGradient(this._background_gradient_cbmi != null && this._background_gradient_cbmi.isSelected());
        options.setShowDomainLabels(this._show_domain_labels != null && this._show_domain_labels.isSelected());
        options.setAbbreviateScientificTaxonNames(this._abbreviate_scientific_names != null && this._abbreviate_scientific_names.isSelected());
        options.setColorLabelsSameAsParentBranch(this._color_labels_same_as_parent_branch != null && this._color_labels_same_as_parent_branch.isSelected());
        options.setShowDefaultNodeShapes(this._show_default_node_shapes_cbmi != null && this._show_default_node_shapes_cbmi.isSelected());
        options.setTaxonomyColorizeNodeShapes(this._taxonomy_colorize_node_shapes_cbmi != null && this._taxonomy_colorize_node_shapes_cbmi.isSelected());
        if (this._non_lined_up_cladograms_rbmi != null && this._non_lined_up_cladograms_rbmi.isSelected()) {
            options.setCladogramType(Options.CLADOGRAM_TYPE.NON_LINED_UP);
        } else if (this._uniform_cladograms_rbmi != null && this._uniform_cladograms_rbmi.isSelected()) {
            options.setCladogramType(Options.CLADOGRAM_TYPE.TOTAL_NODE_SUM_DEP);
        } else if (this._ext_node_dependent_cladogram_rbmi != null && this._ext_node_dependent_cladogram_rbmi.isSelected()) {
            options.setCladogramType(Options.CLADOGRAM_TYPE.EXT_NODE_SUM_DEP);
        }
        options.setSearchCaseSensitive(this._search_case_senstive_cbmi != null && this._search_case_senstive_cbmi.isSelected());
        if (this._show_scale_cbmi != null && this._show_scale_cbmi.isEnabled()) {
            options.setShowScale(this._show_scale_cbmi.isSelected());
        }
        if (this._label_direction_cbmi != null) {
            if (this._label_direction_cbmi.isSelected()) {
                options.setNodeLabelDirection(Options.NODE_LABEL_DIRECTION.RADIAL);
            } else {
                options.setNodeLabelDirection(Options.NODE_LABEL_DIRECTION.HORIZONTAL);
            }
        }
        options.setShowOverview(this._show_overview_cbmi != null && this._show_overview_cbmi.isSelected());
        options.setShowConfidenceStddev(this._show_confidence_stddev_cbmi != null && this._show_confidence_stddev_cbmi.isSelected());
        if (this._show_branch_length_values_cbmi != null && this._show_branch_length_values_cbmi.isEnabled()) {
            options.setShowBranchLengthValues(this._show_branch_length_values_cbmi.isSelected());
        }
        options.setMatchWholeTermsOnly(this._search_whole_words_only_cbmi != null && this._search_whole_words_only_cbmi.isSelected());
        options.setInverseSearchResult(this._inverse_search_result_cbmi != null && this._inverse_search_result_cbmi.isSelected());
        if (this._rectangular_type_cbmi != null && this._rectangular_type_cbmi.isSelected()) {
            options.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.RECTANGULAR);
        } else if (this._triangular_type_cbmi != null && this._triangular_type_cbmi.isSelected()) {
            options.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.TRIANGULAR);
        } else if (this._curved_type_cbmi != null && this._curved_type_cbmi.isSelected()) {
            options.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.CURVED);
        } else if (this._convex_type_cbmi != null && this._convex_type_cbmi.isSelected()) {
            options.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.CONVEX);
        } else if (this._euro_type_cbmi != null && this._euro_type_cbmi.isSelected()) {
            options.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.EURO_STYLE);
        } else if (this._rounded_type_cbmi != null && this._rounded_type_cbmi.isSelected()) {
            options.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.ROUNDED);
        } else if (this._unrooted_type_cbmi != null && this._unrooted_type_cbmi.isSelected()) {
            options.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED);
        } else if (this._circular_type_cbmi != null && this._circular_type_cbmi.isSelected()) {
            options.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR);
        }
    }

    void updateTypeCheckboxes(Options options, Object object) {
        this.setTypeMenuToAllUnselected();
        ((JCheckBoxMenuItem)object).setSelected(true);
    }

    void viewAsNexus() {
        this.removeTextFrame();
        if (this.getMainPanel().getCurrentPhylogeny() == null || this.getMainPanel().getCurrentPhylogeny().isEmpty() || this.getMainPanel().getCurrentPhylogeny().getNumberOfExternalNodes() > 10000) {
            return;
        }
        this._textframe = TextFrame.instantiate(this.getMainPanel().getCurrentPhylogeny().toNexus());
    }

    void viewAsNH() {
        this.removeTextFrame();
        if (this.getMainPanel().getCurrentPhylogeny() == null || this.getMainPanel().getCurrentPhylogeny().isEmpty() || this.getMainPanel().getCurrentPhylogeny().getNumberOfExternalNodes() > 10000) {
            return;
        }
        this._textframe = TextFrame.instantiate(this.getMainPanel().getCurrentPhylogeny().toNewHampshire());
    }

    void viewAsNHX() {
        this.removeTextFrame();
        if (this.getMainPanel().getCurrentPhylogeny() == null || this.getMainPanel().getCurrentPhylogeny().isEmpty() || this.getMainPanel().getCurrentPhylogeny().getNumberOfExternalNodes() > 10000) {
            return;
        }
        this._textframe = TextFrame.instantiate(this.getMainPanel().getCurrentPhylogeny().toNewHampshireX());
    }

    void viewAsXML() {
        this.removeTextFrame();
        if (this.getMainPanel().getCurrentPhylogeny() == null || this.getMainPanel().getCurrentPhylogeny().isEmpty() || this.getMainPanel().getCurrentPhylogeny().getNumberOfExternalNodes() > 10000) {
            return;
        }
        this._textframe = TextFrame.instantiate(this.getMainPanel().getCurrentPhylogeny().toPhyloXML(0));
    }

    static void setupScreenTextAntialias(List<TreePanel> list, boolean bl) {
        for (TreePanel treePanel : list) {
            treePanel.setTextAntialias();
        }
    }
}

