/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx.tools;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JApplet;
import org.forester.archaeopteryx.AptxUtil;
import org.forester.archaeopteryx.TreePanel;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Accession;
import org.forester.util.ForesterUtil;
import org.forester.ws.wabi.RestUtil;

public final class Blast {
    public static final void openNcbiBlastWeb(String string, boolean bl, JApplet jApplet, TreePanel treePanel) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("http://www.ncbi.nlm.nih.gov/blast/Blast.cgi?CMD=Web&DATABASE=nr&PAGE=");
        if (bl) {
            stringBuilder.append("Nucleotide");
        } else {
            stringBuilder.append("Proteins");
        }
        stringBuilder.append("&QUERY=");
        stringBuilder.append(string);
        try {
            AptxUtil.launchWebBrowser(new URI(stringBuilder.toString()), jApplet != null, jApplet, "_aptx_blast");
        }
        catch (IOException iOException) {
            AptxUtil.showErrorMessage(treePanel, iOException.toString());
            iOException.printStackTrace();
        }
        catch (URISyntaxException uRISyntaxException) {
            AptxUtil.showErrorMessage(treePanel, uRISyntaxException.toString());
            uRISyntaxException.printStackTrace();
        }
    }

    public static final String obtainQueryForBlast(PhylogenyNode phylogenyNode) {
        Accession accession;
        String string = "";
        if (!ForesterUtil.isEmpty(phylogenyNode.getNodeData().getSequence().getMolecularSequence())) {
            string = phylogenyNode.getNodeData().getSequence().getMolecularSequence();
        } else if (phylogenyNode.getNodeData().getSequence().getAccession() != null && !ForesterUtil.isEmpty(phylogenyNode.getNodeData().getSequence().getAccession().getValue())) {
            if (!ForesterUtil.isEmpty(phylogenyNode.getNodeData().getSequence().getAccession().getSource())) {
                string = phylogenyNode.getNodeData().getSequence().getAccession().getSource() + "%7C";
            }
            string = string + phylogenyNode.getNodeData().getSequence().getAccession().getValue();
        } else if (!ForesterUtil.isEmpty(phylogenyNode.getNodeData().getSequence().getName()) && (accession = AptxUtil.obtainSequenceAccessionFromName(phylogenyNode.getNodeData().getSequence().getName())) != null) {
            string = accession.getSource() + "%7C" + accession.getValue();
        }
        return string;
    }

    public static final boolean isContainsQueryForBlast(PhylogenyNode phylogenyNode) {
        return !ForesterUtil.isEmpty(Blast.obtainQueryForBlast(phylogenyNode));
    }

    public final void ddbjBlast(String string) {
        Object[] objectArray;
        String string2 = "/ENTRY/DDBJ/division=='HUM' AND (/ENTRY/DDBJ/length>=300 AND /ENTRY/DDBJ/length<=1000) ";
        string2 = string2 + "AND (/ENTRY/DDBJ/feature-table/feature{/f_key = 'CDS' AND ";
        string2 = string2 + "/f_quals/qualifier{/q_name = 'gene' AND /q_value=='" + string + "'}})";
        String string3 = "service=ARSA&method=searchByXMLPath&queryPath=" + string2 + "&returnPath=/ENTRY/DDBJ/primary-accession&offset=1&count=100";
        String string4 = null;
        try {
            string4 = RestUtil.getResult(string3);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        String[] stringArray = string4.split("\n");
        int n = Integer.parseInt(stringArray[0].replaceAll("hitscount       =", "").trim());
        if (n == 0) {
            System.out.println("There is no entry for gene:" + string);
            return;
        }
        String string5 = stringArray[2];
        string3 = "service=GetEntry&method=getFASTA_DDBJEntry&accession=" + string5;
        String string6 = null;
        try {
            string6 = RestUtil.getResult(string3);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        System.out.println("Retrieved DNA sequence is: " + string6);
        string3 = "service=Blast&method=searchParam&program=blastn&database=ddbjpri ddbjrod ddbjmam ddbjvrt ddbjinv&query=" + string6 + "&param=-m 8 -b 50 -v 50 -e 0.0001";
        String string7 = null;
        try {
            string7 = RestUtil.getResult(string3);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        String[] stringArray2 = string7.split("\n");
        Vector<String[]> vector = new Vector<String[]>();
        for (String string8 : stringArray2) {
            objectArray = string8.split("\t");
            String string9 = objectArray[1].substring(0, objectArray[1].indexOf("|"));
            String[] stringArray3 = new String[]{string9, objectArray[2]};
            vector.add(stringArray3);
        }
        Hashtable hashtable = new Hashtable();
        for (int i = 0; i < vector.size(); ++i) {
            String string8;
            String[] stringArray4 = (String[])vector.elementAt(i);
            string3 = "service=ARSA&method=searchByXMLPath&queryPath=/ENTRY/DDBJ/primary-accession=='" + stringArray4[0] + "'&returnPath=/ENTRY/DDBJ/organism&offset=1&count=100";
            string8 = null;
            try {
                string8 = RestUtil.getResult(string3);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            objectArray = string8.split("\n");
            string8 = objectArray[2];
            if (hashtable.containsKey(string8)) continue;
            hashtable.put(string8, stringArray4[0] + "\t" + stringArray4[1]);
        }
        System.out.println("DDBJ entries: " + n);
        System.out.println("Representative accession: " + string5);
        System.out.println("Organism name\tDDBJ accession number\tSequence similarity");
        Object[] objectArray2 = new String[hashtable.size()];
        Enumeration enumeration = hashtable.keys();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            objectArray2[n2] = (String)enumeration.nextElement();
            ++n2;
        }
        Arrays.sort(objectArray2);
        for (Object object : objectArray2) {
            System.out.println((String)object + "\t" + (String)hashtable.get(object));
        }
    }
}

