/*
 * Decompiled with CFR 0.152.
 */
package org.forester.go;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.forester.go.GoId;
import org.forester.go.PfamToGoMapping;
import org.forester.protein.DomainId;
import org.forester.util.ForesterUtil;

public class PfamToGoParser {
    private static final String PFAM_TO_GO_FORMAT = "Pfam:\\S+\\s+(\\S+)\\s*>\\s*GO:.+;\\s*(\\S+)";
    private static final Pattern PFAM_TO_GO_PATTERN = Pattern.compile("Pfam:\\S+\\s+(\\S+)\\s*>\\s*GO:.+;\\s*(\\S+)");
    private static final String PFAMACC_TO_GO_FORMAT = "Pfam:(\\S+)\\s+\\S+\\s*>\\s*GO:.+;\\s*(\\S+)";
    private static final Pattern PFAMACC_TO_GO_PATTERN = Pattern.compile("Pfam:(\\S+)\\s+\\S+\\s*>\\s*GO:.+;\\s*(\\S+)");
    private final File _input_file;
    private int _mapping_count;
    private boolean _use_acc;

    public PfamToGoParser(File file) {
        this._input_file = file;
        this.init();
    }

    private File getInputFile() {
        return this._input_file;
    }

    public int getMappingCount() {
        return this._mapping_count;
    }

    private void init() {
        this.setMappingCount(0);
        this.setUseAccessors(false);
    }

    public boolean isUseAccessors() {
        return this._use_acc;
    }

    public List<PfamToGoMapping> parse() throws IOException {
        String string = ForesterUtil.isReadableFile(this.getInputFile());
        if (!ForesterUtil.isEmpty(string)) {
            throw new IOException(string);
        }
        BufferedReader bufferedReader = new BufferedReader(new FileReader(this.getInputFile()));
        ArrayList<PfamToGoMapping> arrayList = new ArrayList<PfamToGoMapping>();
        int n = 0;
        try {
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                ++n;
                if ((string2 = string2.trim()).length() <= 0 || string2.startsWith("!")) continue;
                Matcher matcher = null;
                matcher = this.isUseAccessors() ? PFAMACC_TO_GO_PATTERN.matcher(string2) : PFAM_TO_GO_PATTERN.matcher(string2);
                if (!matcher.matches()) {
                    throw new IOException("unexpected format [\"" + string2 + "\"]");
                }
                if (matcher.groupCount() != 2) {
                    throw new IOException("unexpected format [\"" + string2 + "\"]");
                }
                String string3 = matcher.group(1);
                String string4 = matcher.group(2);
                if (ForesterUtil.isEmpty(string3) || ForesterUtil.isEmpty(string4)) {
                    throw new IOException("unexpected format [\"" + string2 + "\"]");
                }
                PfamToGoMapping pfamToGoMapping = new PfamToGoMapping(new DomainId(string3), new GoId(string4));
                ++this._mapping_count;
                arrayList.add(pfamToGoMapping);
            }
        }
        catch (Exception exception) {
            throw new IOException("parsing problem: " + exception.getMessage() + " [at line " + n + "]");
        }
        return arrayList;
    }

    private void setMappingCount(int n) {
        this._mapping_count = n;
    }

    public void setUseAccessors(boolean bl) {
        this._use_acc = bl;
    }
}

