/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.parsers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.forester.protein.BasicDomain;
import org.forester.protein.BasicProtein;
import org.forester.protein.Domain;
import org.forester.protein.DomainId;
import org.forester.protein.Protein;
import org.forester.surfacing.SurfacingUtil;
import org.forester.util.ForesterUtil;

public final class HmmPfamOutputParser {
    private static final String RETRO = "RETRO";
    private static final String PHAGE = "PHAGE";
    private static final String VIR = "VIR";
    private static final String TRANSPOS = "TRANSPOS";
    private static final String RV = "RV";
    private static final String GAG = "GAG_";
    private static final String HCV = "HCV_";
    private static final String HERPES = "Herpes_";
    private static final int E_VALUE_MAXIMUM_DEFAULT = -1;
    private static final ReturnType RETURN_TYPE_DEFAULT = ReturnType.UNORDERED_PROTEIN_DOMAIN_COLLECTION_PER_PROTEIN;
    private static final boolean IGNORE_DUFS_DEFAULT = false;
    private static final int MAX_ALLOWED_OVERLAP_DEFAULT = -1;
    private final Set<DomainId> _filter;
    private final FilterType _filter_type;
    private final File _input_file;
    private final String _species;
    private final String _model_type;
    private double _e_value_maximum;
    private Map<String, String> _individual_domain_score_cutoffs;
    private boolean _ignore_dufs;
    private boolean _ignore_virus_like_ids;
    private boolean _allow_non_unique_query;
    private boolean _verbose;
    private int _max_allowed_overlap;
    private boolean _ignore_engulfed_domains;
    private ReturnType _return_type;
    private int _proteins_encountered;
    private int _proteins_ignored_due_to_filter;
    private int _proteins_stored;
    private int _domains_encountered;
    private int _domains_ignored_due_to_duf;
    private int _domains_ignored_due_to_overlap;
    private int _domains_ignored_due_to_e_value;
    private int _domains_ignored_due_to_individual_score_cutoff;
    private int _domains_stored;
    private SortedSet<DomainId> _domains_stored_set;
    private long _time;
    private int _domains_ignored_due_to_negative_domain_filter;
    private Map<String, Integer> _domains_ignored_due_to_negative_domain_filter_counts_map;
    private int _domains_ignored_due_to_virus_like_id;
    private Map<String, Integer> _domains_ignored_due_to_virus_like_id_counts_map;

    public HmmPfamOutputParser(File file, String string, String string2) {
        this._input_file = file;
        this._species = string;
        this._model_type = string2;
        this._filter = null;
        this._filter_type = FilterType.NONE;
        this.init();
    }

    public HmmPfamOutputParser(File file, String string, String string2, Set<DomainId> set, FilterType filterType) {
        this._input_file = file;
        this._species = string;
        this._model_type = string2;
        this._filter = set;
        this._filter_type = filterType;
        this.init();
    }

    private void actuallyAddProtein(List<Protein> list, Protein protein) {
        List<Domain> list2 = protein.getProteinDomains();
        for (Domain domain : list2) {
            this.getDomainsStoredSet().add(domain.getDomainId());
        }
        list.add(protein);
        ++this._proteins_stored;
    }

    private void addProtein(List<Protein> list, Protein protein) {
        if (this.getFilterType() == FilterType.POSITIVE_PROTEIN || this.getFilterType() == FilterType.NEGATIVE_PROTEIN) {
            HashSet<DomainId> hashSet = new HashSet<DomainId>();
            for (Domain domain : protein.getProteinDomains()) {
                hashSet.add(domain.getDomainId());
            }
            hashSet.retainAll(this.getFilter());
            if (this.getFilterType() == FilterType.POSITIVE_PROTEIN) {
                if (hashSet.size() > 0) {
                    this.actuallyAddProtein(list, protein);
                } else {
                    ++this._proteins_ignored_due_to_filter;
                }
            } else if (hashSet.size() < 1) {
                this.actuallyAddProtein(list, protein);
            } else {
                ++this._proteins_ignored_due_to_filter;
            }
        } else {
            this.actuallyAddProtein(list, protein);
        }
    }

    public int getDomainsEncountered() {
        return this._domains_encountered;
    }

    public int getDomainsIgnoredDueToDuf() {
        return this._domains_ignored_due_to_duf;
    }

    public int getDomainsIgnoredDueToEval() {
        return this._domains_ignored_due_to_e_value;
    }

    public int getDomainsIgnoredDueToIndividualScoreCutoff() {
        return this._domains_ignored_due_to_individual_score_cutoff;
    }

    public int getDomainsIgnoredDueToNegativeDomainFilter() {
        return this._domains_ignored_due_to_negative_domain_filter;
    }

    public Map<String, Integer> getDomainsIgnoredDueToNegativeDomainFilterCountsMap() {
        return this._domains_ignored_due_to_negative_domain_filter_counts_map;
    }

    public int getDomainsIgnoredDueToOverlap() {
        return this._domains_ignored_due_to_overlap;
    }

    public Map<String, Integer> getDomainsIgnoredDueToVirusLikeIdCountsMap() {
        return this._domains_ignored_due_to_virus_like_id_counts_map;
    }

    public int getDomainsIgnoredDueToVirusLikeIds() {
        return this._domains_ignored_due_to_virus_like_id;
    }

    public int getDomainsStored() {
        return this._domains_stored;
    }

    public SortedSet<DomainId> getDomainsStoredSet() {
        return this._domains_stored_set;
    }

    private double getEValueMaximum() {
        return this._e_value_maximum;
    }

    private Set<DomainId> getFilter() {
        return this._filter;
    }

    private FilterType getFilterType() {
        return this._filter_type;
    }

    private Map<String, String> getIndividualDomainScoreCutoffs() {
        return this._individual_domain_score_cutoffs;
    }

    private File getInputFile() {
        return this._input_file;
    }

    private int getMaxAllowedOverlap() {
        return this._max_allowed_overlap;
    }

    private String getModelType() {
        return this._model_type;
    }

    public int getProteinsEncountered() {
        return this._proteins_encountered;
    }

    public int getProteinsIgnoredDueToFilter() {
        return this._proteins_ignored_due_to_filter;
    }

    public int getProteinsStored() {
        return this._proteins_stored;
    }

    private ReturnType getReturnType() {
        return this._return_type;
    }

    private String getSpecies() {
        return this._species;
    }

    public long getTime() {
        return this._time;
    }

    private void init() {
        this._e_value_maximum = -1.0;
        this.setIgnoreDufs(false);
        this.setReturnType(RETURN_TYPE_DEFAULT);
        this._max_allowed_overlap = -1;
        this.setIndividualDomainScoreCutoffs(null);
        this.setIgnoreEngulfedDomains(false);
        this.setIgnoreVirusLikeIds(false);
        this.setAllowNonUniqueQuery(false);
        this.setVerbose(false);
        this.intitCounts();
    }

    private void intitCounts() {
        this.setDomainsStoredSet(new TreeSet<DomainId>());
        this.setDomainsEncountered(0);
        this.setProteinsEncountered(0);
        this.setProteinsIgnoredDueToFilter(0);
        this.setDomainsIgnoredDueToNegativeFilter(0);
        this.setDomainsIgnoredDueToDuf(0);
        this.setDomainsIgnoredDueToEval(0);
        this.setDomainsIgnoredDueToIndividualScoreCutoff(0);
        this.setDomainsIgnoredDueToVirusLikeId(0);
        this.setDomainsIgnoredDueToOverlap(0);
        this.setDomainsStored(0);
        this.setProteinsStored(0);
        this.setTime(0L);
        this.setDomainsIgnoredDueToVirusLikeIdCountsMap(new TreeMap<String, Integer>());
        this.setDomainsIgnoredDueToNegativeDomainFilterCountsMap(new TreeMap<String, Integer>());
    }

    private boolean isAllowNonUniqueQuery() {
        return this._allow_non_unique_query;
    }

    private boolean isIgnoreDufs() {
        return this._ignore_dufs;
    }

    private boolean isIgnoreEngulfedDomains() {
        return this._ignore_engulfed_domains;
    }

    private boolean isIgnoreVirusLikeIds() {
        return this._ignore_virus_like_ids;
    }

    private boolean isVerbose() {
        return this._verbose;
    }

    public List<Protein> parse() throws IOException {
        String string;
        this.intitCounts();
        HashSet<String[]> hashSet = new HashSet<String[]>();
        String string2 = ForesterUtil.isReadableFile(this.getInputFile());
        if (!ForesterUtil.isEmpty(string2)) {
            throw new IOException(string2);
        }
        BufferedReader bufferedReader = new BufferedReader(new FileReader(this.getInputFile()));
        ArrayList<Protein> arrayList = new ArrayList<Protein>();
        Protein protein = null;
        int n = 0;
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        long l = new Date().getTime();
        while ((string = bufferedReader.readLine()) != null) {
            String[] stringArray;
            ++n;
            if (string.length() < 1) continue;
            if (string.startsWith("Query sequence:")) {
                ++this._proteins_encountered;
                if (!bl) {
                    throw new IOException("unexpected format [line " + n + "] in [" + this.getInputFile().getCanonicalPath() + "]");
                }
                bl = false;
                bl4 = true;
                bl5 = false;
                stringArray = string.substring(16).trim();
                if (ForesterUtil.isEmpty((String)stringArray)) {
                    throw new IOException("query sequence cannot be empty [line " + n + "] in [" + this.getInputFile().getCanonicalPath() + "]");
                }
                if (hashSet.contains(stringArray)) {
                    if (!this.isAllowNonUniqueQuery()) {
                        throw new IOException("query \"" + (String)stringArray + "\" is not unique [line " + n + "] in [" + this.getInputFile().getCanonicalPath() + "]");
                    }
                    if (this.isVerbose()) {
                        ForesterUtil.printWarningMessage(this.getClass().getName(), "query \"" + (String)stringArray + "\" is not unique [line " + n + "] in [" + this.getInputFile().getCanonicalPath() + "]");
                    }
                } else {
                    hashSet.add(stringArray);
                }
                if (protein != null) {
                    throw new IOException("unexpected format [line " + n + "] in [" + this.getInputFile().getCanonicalPath() + "]");
                }
                if (this.getReturnType() == ReturnType.UNORDERED_PROTEIN_DOMAIN_COLLECTION_PER_PROTEIN) {
                    protein = new BasicProtein((String)stringArray, this.getSpecies(), 0);
                    continue;
                }
                throw new IllegalArgumentException("unknown return type");
            }
            if (string.startsWith("Accession:")) {
                if (!bl4 || protein == null) {
                    throw new IOException("unexpected format [line " + n + "] in [" + this.getInputFile().getCanonicalPath() + "]");
                }
                ((BasicProtein)protein).setAccession(string.substring(11).trim());
                continue;
            }
            if (string.startsWith("Description:")) {
                if (!bl4 || protein == null) {
                    throw new IOException("unexpected format [line " + n + "] in [" + this.getInputFile().getCanonicalPath() + "]");
                }
                if (bl5) {
                    if (this.getReturnType() != ReturnType.UNORDERED_PROTEIN_DOMAIN_COLLECTION_PER_PROTEIN) continue;
                    protein = new BasicProtein(protein.getProteinId() + " " + string.substring(13).trim(), this.getSpecies(), 0);
                    continue;
                }
                ((BasicProtein)protein).setDescription(string.substring(13).trim());
                continue;
            }
            if (string.startsWith("Parsed for domains:")) {
                if (!bl4) {
                    throw new IOException("unexpected format [line " + n + "] in [" + this.getInputFile().getCanonicalPath() + "]");
                }
                bl4 = false;
                bl3 = true;
                continue;
            }
            if (bl3 && string.startsWith("--------")) {
                bl2 = true;
                bl3 = false;
                continue;
            }
            if (string.startsWith("Alignments of top-scoring domains:")) {
                if (!bl2) {
                    throw new IOException("unexpected format [line " + n + "] in [" + this.getInputFile().getCanonicalPath() + "]");
                }
                bl2 = false;
                continue;
            }
            if (string.startsWith("//")) {
                bl2 = false;
                bl = true;
                if (protein.getProteinDomains().size() > 0) {
                    if (this.getMaxAllowedOverlap() != -1 || this.isIgnoreEngulfedDomains()) {
                        int n2 = protein.getNumberOfProteinDomains();
                        protein = SurfacingUtil.removeOverlappingDomains(this.getMaxAllowedOverlap(), this.isIgnoreEngulfedDomains(), protein);
                        int n3 = n2 - protein.getNumberOfProteinDomains();
                        this._domains_stored -= n3;
                        this._domains_ignored_due_to_overlap += n3;
                    }
                    this.addProtein(arrayList, protein);
                }
                protein = null;
                continue;
            }
            if (!bl2 || string.indexOf("[no hits above thresholds]") != -1) continue;
            stringArray = string.split("\\s+");
            if (stringArray.length != 10) {
                throw new IOException("unexpected format in hmmpfam output:  \"" + string + "\" [line " + n + "] in [" + this.getInputFile().getCanonicalPath() + "]");
            }
            String string3 = stringArray[0];
            String string4 = stringArray[1];
            String string5 = stringArray[2];
            String string6 = stringArray[3];
            String string7 = stringArray[4];
            String string8 = stringArray[7];
            String string9 = stringArray[8];
            String string10 = stringArray[9];
            int n4 = -1;
            int n5 = -1;
            double d = -1.0;
            double d2 = -1.0;
            boolean bl6 = false;
            boolean bl7 = false;
            try {
                n4 = Integer.valueOf(string5);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException("could not parse seq-f from \"" + string + "\" [line " + n + "] in [" + this.getInputFile().getCanonicalPath() + "]");
            }
            try {
                n5 = Integer.valueOf(string6);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException("could not parse seq-t from \"" + string + "\" [line " + n + "] in [" + this.getInputFile().getCanonicalPath() + "]");
            }
            try {
                d2 = Double.valueOf(string9);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException("could not parse score from \"" + string + "\" [line " + n + "] in [" + this.getInputFile().getCanonicalPath() + "]");
            }
            try {
                d = Double.valueOf(string10);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException("could not parse E-value from \"" + string + "\" [line " + n + "] in [" + this.getInputFile().getCanonicalPath() + "]");
            }
            if (string8.equals("[]")) {
                bl6 = true;
            } else if (!(string8.equals(".]") || string8.equals("[.") || string8.equals(".."))) {
                throw new IOException("unexpected format in hmmpfam output:  \"" + string + "\" [line " + n + "] in [" + this.getInputFile().getCanonicalPath() + "]");
            }
            if (string7.equals("..")) {
                bl7 = true;
            } else if (!(string7.equals(".]") || string7.equals("[.") || string7.equals("[]"))) {
                throw new IOException("unexpected format in hmmpfam output:  \"" + string + "\" [line " + n + "] in [" + this.getInputFile().getCanonicalPath() + "]");
            }
            String[] stringArray2 = string4.split("/");
            if (stringArray2.length != 2) {
                throw new IOException("unexpected format in hmmpfam output:  \"" + string + "\" [line " + n + "] in [" + this.getInputFile().getCanonicalPath() + "]");
            }
            String string11 = stringArray2[0];
            String string12 = stringArray2[1];
            int n6 = -1;
            int n7 = -1;
            try {
                n6 = Integer.valueOf(string11);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException("could not parse domain number from \"" + string + "\" [line " + n + "] in [" + this.getInputFile().getCanonicalPath() + "]");
            }
            try {
                n7 = Integer.valueOf(string12);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException("could not parse domain count from \"" + string + "\" [line " + n + "] in [" + this.getInputFile().getCanonicalPath() + "]");
            }
            ++this._domains_encountered;
            boolean bl8 = false;
            if (this.getIndividualDomainScoreCutoffs() != null) {
                if (this.getIndividualDomainScoreCutoffs().containsKey(string3)) {
                    double d3 = Double.parseDouble(this.getIndividualDomainScoreCutoffs().get(string3));
                    if (d2 < d3) {
                        bl8 = true;
                    }
                } else {
                    throw new IOException("could not find a score cutoff value for domain id \"" + string3 + "\" [line " + n + "] in [" + this.getInputFile().getCanonicalPath() + "]");
                }
            }
            String string13 = string3.toUpperCase();
            if (bl8) {
                ++this._domains_ignored_due_to_individual_score_cutoff;
                continue;
            }
            if (this.getEValueMaximum() != -1.0 && d > this.getEValueMaximum()) {
                ++this._domains_ignored_due_to_e_value;
                continue;
            }
            if (this.isIgnoreDufs() && string13.startsWith("DUF")) {
                ++this._domains_ignored_due_to_duf;
                continue;
            }
            if (this.isIgnoreVirusLikeIds() && (string13.contains(VIR) || string13.contains(PHAGE) || string13.contains(RETRO) || string13.contains(TRANSPOS) || string13.startsWith(RV) || string13.startsWith(GAG) || string13.startsWith(HCV) || string13.startsWith(HERPES))) {
                ForesterUtil.increaseCountingMap(this.getDomainsIgnoredDueToVirusLikeIdCountsMap(), string3);
                ++this._domains_ignored_due_to_virus_like_id;
                continue;
            }
            if (this.getFilterType() == FilterType.NEGATIVE_DOMAIN && this.getFilter().contains(new DomainId(string3))) {
                ++this._domains_ignored_due_to_negative_domain_filter;
                ForesterUtil.increaseCountingMap(this.getDomainsIgnoredDueToNegativeDomainFilterCountsMap(), string3);
                continue;
            }
            BasicDomain basicDomain = new BasicDomain(string3, n4, n5, (short)n6, (short)n7, d, d2);
            protein.addProteinDomain(basicDomain);
            ++this._domains_stored;
        }
        this.setTime(new Date().getTime() - l);
        if (!bl) {
            throw new IOException("file ends unexpectedly [line " + n + "]");
        }
        return arrayList;
    }

    public void setAllowNonUniqueQuery(boolean bl) {
        this._allow_non_unique_query = bl;
    }

    private void setDomainsEncountered(int n) {
        this._domains_encountered = n;
    }

    private void setDomainsIgnoredDueToDuf(int n) {
        this._domains_ignored_due_to_duf = n;
    }

    public void setDomainsIgnoredDueToEval(int n) {
        this._domains_ignored_due_to_e_value = n;
    }

    public void setDomainsIgnoredDueToIndividualScoreCutoff(int n) {
        this._domains_ignored_due_to_individual_score_cutoff = n;
    }

    private void setDomainsIgnoredDueToNegativeDomainFilterCountsMap(Map<String, Integer> map) {
        this._domains_ignored_due_to_negative_domain_filter_counts_map = map;
    }

    private void setDomainsIgnoredDueToNegativeFilter(int n) {
        this._domains_ignored_due_to_negative_domain_filter = n;
    }

    private void setDomainsIgnoredDueToOverlap(int n) {
        this._domains_ignored_due_to_overlap = n;
    }

    private void setDomainsIgnoredDueToVirusLikeId(int n) {
        this._domains_ignored_due_to_virus_like_id = n;
    }

    private void setDomainsIgnoredDueToVirusLikeIdCountsMap(Map<String, Integer> map) {
        this._domains_ignored_due_to_virus_like_id_counts_map = map;
    }

    private void setDomainsStored(int n) {
        this._domains_stored = n;
    }

    private void setDomainsStoredSet(SortedSet<DomainId> sortedSet) {
        this._domains_stored_set = sortedSet;
    }

    public void setEValueMaximum(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("attempt to set the maximum E-value to a negative value");
        }
        this._e_value_maximum = d;
    }

    public void setIgnoreDufs(boolean bl) {
        this._ignore_dufs = bl;
    }

    public void setIgnoreEngulfedDomains(boolean bl) {
        this._ignore_engulfed_domains = bl;
    }

    public void setIgnoreVirusLikeIds(boolean bl) {
        this._ignore_virus_like_ids = bl;
    }

    public void setIndividualDomainScoreCutoffs(Map<String, String> map) {
        this._individual_domain_score_cutoffs = map;
    }

    public void setMaxAllowedOverlap(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Attempt to set max allowed overlap to less than zero.");
        }
        this._max_allowed_overlap = n;
    }

    private void setProteinsEncountered(int n) {
        this._proteins_encountered = n;
    }

    private void setProteinsIgnoredDueToFilter(int n) {
        this._proteins_ignored_due_to_filter = n;
    }

    private void setProteinsStored(int n) {
        this._proteins_stored = n;
    }

    public void setReturnType(ReturnType returnType) {
        this._return_type = returnType;
    }

    private void setTime(long l) {
        this._time = l;
    }

    public void setVerbose(boolean bl) {
        this._verbose = bl;
    }

    public static enum ReturnType {
        UNORDERED_PROTEIN_DOMAIN_COLLECTION_PER_PROTEIN;

    }

    public static enum FilterType {
        NONE,
        POSITIVE_PROTEIN,
        NEGATIVE_PROTEIN,
        NEGATIVE_DOMAIN;

    }
}

