/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.parsers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.forester.protein.BasicDomain;
import org.forester.protein.BasicProtein;
import org.forester.protein.Domain;
import org.forester.protein.DomainId;
import org.forester.protein.Protein;
import org.forester.surfacing.SurfacingUtil;
import org.forester.util.ForesterUtil;

public final class HmmscanPerDomainTableParser {
    private static final String RETRO = "RETRO";
    private static final String PHAGE = "PHAGE";
    private static final String VIR = "VIR";
    private static final String TRANSPOS = "TRANSPOS";
    private static final String RV = "RV";
    private static final String GAG = "GAG_";
    private static final String HCV = "HCV_";
    private static final String HERPES = "HERPES_";
    private static final String BACULO = "BACULO_";
    private static final int E_VALUE_MAXIMUM_DEFAULT = -1;
    private static final ReturnType RETURN_TYPE_DEFAULT = ReturnType.UNORDERED_PROTEIN_DOMAIN_COLLECTION_PER_PROTEIN;
    private static final boolean IGNORE_DUFS_DEFAULT = false;
    private static final int MAX_ALLOWED_OVERLAP_DEFAULT = -1;
    private final Set<DomainId> _filter;
    private final FilterType _filter_type;
    private final File _input_file;
    private final String _species;
    private double _e_value_maximum;
    private Map<String, Double> _individual_score_cutoffs;
    private boolean _ignore_dufs;
    private boolean _ignore_virus_like_ids;
    private int _max_allowed_overlap;
    private boolean _ignore_engulfed_domains;
    private ReturnType _return_type;
    private int _proteins_encountered;
    private int _proteins_ignored_due_to_filter;
    private int _proteins_stored;
    private int _domains_encountered;
    private int _domains_ignored_due_to_duf;
    private int _domains_ignored_due_to_overlap;
    private int _domains_ignored_due_to_e_value;
    private int _domains_ignored_due_to_individual_score_cutoff;
    private int _domains_stored;
    private SortedSet<DomainId> _domains_stored_set;
    private long _time;
    private int _domains_ignored_due_to_negative_domain_filter;
    private Map<String, Integer> _domains_ignored_due_to_negative_domain_filter_counts_map;
    private int _domains_ignored_due_to_virus_like_id;
    private Map<String, Integer> _domains_ignored_due_to_virus_like_id_counts_map;
    private final INDIVIDUAL_SCORE_CUTOFF _ind_cutoff;
    private final boolean _allow_proteins_with_same_name;

    public HmmscanPerDomainTableParser(File file, String string, INDIVIDUAL_SCORE_CUTOFF iNDIVIDUAL_SCORE_CUTOFF) {
        this._input_file = file;
        this._species = string;
        this._filter = null;
        this._filter_type = FilterType.NONE;
        this._ind_cutoff = iNDIVIDUAL_SCORE_CUTOFF;
        this._allow_proteins_with_same_name = false;
        this.init();
    }

    public HmmscanPerDomainTableParser(File file, String string, INDIVIDUAL_SCORE_CUTOFF iNDIVIDUAL_SCORE_CUTOFF, boolean bl) {
        this._input_file = file;
        this._species = string;
        this._filter = null;
        this._filter_type = FilterType.NONE;
        this._ind_cutoff = iNDIVIDUAL_SCORE_CUTOFF;
        this._allow_proteins_with_same_name = bl;
        this.init();
    }

    public HmmscanPerDomainTableParser(File file, String string, Set<DomainId> set, FilterType filterType, INDIVIDUAL_SCORE_CUTOFF iNDIVIDUAL_SCORE_CUTOFF) {
        this._input_file = file;
        this._species = string;
        this._filter = set;
        this._filter_type = filterType;
        this._ind_cutoff = iNDIVIDUAL_SCORE_CUTOFF;
        this._allow_proteins_with_same_name = false;
        this.init();
    }

    public HmmscanPerDomainTableParser(File file, String string, Set<DomainId> set, FilterType filterType, INDIVIDUAL_SCORE_CUTOFF iNDIVIDUAL_SCORE_CUTOFF, boolean bl) {
        this._input_file = file;
        this._species = string;
        this._filter = set;
        this._filter_type = filterType;
        this._ind_cutoff = iNDIVIDUAL_SCORE_CUTOFF;
        this._allow_proteins_with_same_name = bl;
        this.init();
    }

    public boolean isAllowProteinsWithSameName() {
        return this._allow_proteins_with_same_name;
    }

    private void actuallyAddProtein(List<Protein> list, Protein protein) {
        List<Domain> list2 = protein.getProteinDomains();
        for (Domain domain : list2) {
            this.getDomainsStoredSet().add(domain.getDomainId());
        }
        list.add(protein);
        ++this._proteins_stored;
    }

    private void addProtein(List<Protein> list, Protein protein) {
        if (this.getMaxAllowedOverlap() != -1 || this.isIgnoreEngulfedDomains()) {
            int n = protein.getNumberOfProteinDomains();
            protein = SurfacingUtil.removeOverlappingDomains(this.getMaxAllowedOverlap(), this.isIgnoreEngulfedDomains(), protein);
            int n2 = n - protein.getNumberOfProteinDomains();
            this._domains_stored -= n2;
            this._domains_ignored_due_to_overlap += n2;
        }
        if (this.getFilterType() == FilterType.POSITIVE_PROTEIN || this.getFilterType() == FilterType.NEGATIVE_PROTEIN) {
            HashSet<DomainId> hashSet = new HashSet<DomainId>();
            for (Domain domain : protein.getProteinDomains()) {
                hashSet.add(domain.getDomainId());
            }
            hashSet.retainAll(this.getFilter());
            if (this.getFilterType() == FilterType.POSITIVE_PROTEIN) {
                if (hashSet.size() > 0) {
                    this.actuallyAddProtein(list, protein);
                } else {
                    ++this._proteins_ignored_due_to_filter;
                }
            } else if (hashSet.size() < 1) {
                this.actuallyAddProtein(list, protein);
            } else {
                ++this._proteins_ignored_due_to_filter;
            }
        } else {
            this.actuallyAddProtein(list, protein);
        }
    }

    public int getDomainsEncountered() {
        return this._domains_encountered;
    }

    public int getDomainsIgnoredDueToDuf() {
        return this._domains_ignored_due_to_duf;
    }

    public int getDomainsIgnoredDueToEval() {
        return this._domains_ignored_due_to_e_value;
    }

    public int getDomainsIgnoredDueToIndividualScoreCutoff() {
        return this._domains_ignored_due_to_individual_score_cutoff;
    }

    public int getDomainsIgnoredDueToNegativeDomainFilter() {
        return this._domains_ignored_due_to_negative_domain_filter;
    }

    public Map<String, Integer> getDomainsIgnoredDueToNegativeDomainFilterCountsMap() {
        return this._domains_ignored_due_to_negative_domain_filter_counts_map;
    }

    public int getDomainsIgnoredDueToOverlap() {
        return this._domains_ignored_due_to_overlap;
    }

    public Map<String, Integer> getDomainsIgnoredDueToVirusLikeIdCountsMap() {
        return this._domains_ignored_due_to_virus_like_id_counts_map;
    }

    public int getDomainsIgnoredDueToVirusLikeIds() {
        return this._domains_ignored_due_to_virus_like_id;
    }

    public int getDomainsStored() {
        return this._domains_stored;
    }

    public SortedSet<DomainId> getDomainsStoredSet() {
        return this._domains_stored_set;
    }

    private double getEValueMaximum() {
        return this._e_value_maximum;
    }

    private Set<DomainId> getFilter() {
        return this._filter;
    }

    private FilterType getFilterType() {
        return this._filter_type;
    }

    public INDIVIDUAL_SCORE_CUTOFF getIndividualCutoffAppliesTo() {
        return this._ind_cutoff;
    }

    private Map<String, Double> getIndividualScoreCutoffs() {
        return this._individual_score_cutoffs;
    }

    private File getInputFile() {
        return this._input_file;
    }

    private int getMaxAllowedOverlap() {
        return this._max_allowed_overlap;
    }

    public int getProteinsEncountered() {
        return this._proteins_encountered;
    }

    public int getProteinsIgnoredDueToFilter() {
        return this._proteins_ignored_due_to_filter;
    }

    public int getProteinsStored() {
        return this._proteins_stored;
    }

    private ReturnType getReturnType() {
        return this._return_type;
    }

    private String getSpecies() {
        return this._species;
    }

    public long getTime() {
        return this._time;
    }

    private void init() {
        this._e_value_maximum = -1.0;
        this.setIgnoreDufs(false);
        this.setReturnType(RETURN_TYPE_DEFAULT);
        this._max_allowed_overlap = -1;
        this.setIndividualScoreCutoffs(null);
        this.setIgnoreEngulfedDomains(false);
        this.setIgnoreVirusLikeIds(false);
        this.intitCounts();
    }

    private void intitCounts() {
        this.setDomainsStoredSet(new TreeSet<DomainId>());
        this.setDomainsEncountered(0);
        this.setProteinsEncountered(0);
        this.setProteinsIgnoredDueToFilter(0);
        this.setDomainsIgnoredDueToNegativeFilter(0);
        this.setDomainsIgnoredDueToDuf(0);
        this.setDomainsIgnoredDueToEval(0);
        this.setDomainsIgnoredDueToIndividualScoreCutoff(0);
        this.setDomainsIgnoredDueToVirusLikeId(0);
        this.setDomainsIgnoredDueToOverlap(0);
        this.setDomainsStored(0);
        this.setProteinsStored(0);
        this.setTime(0L);
        this.setDomainsIgnoredDueToVirusLikeIdCountsMap(new TreeMap<String, Integer>());
        this.setDomainsIgnoredDueToNegativeDomainFilterCountsMap(new TreeMap<String, Integer>());
    }

    private boolean isIgnoreDufs() {
        return this._ignore_dufs;
    }

    private boolean isIgnoreEngulfedDomains() {
        return this._ignore_engulfed_domains;
    }

    private boolean isIgnoreVirusLikeIds() {
        return this._ignore_virus_like_ids;
    }

    public List<Protein> parse() throws IOException {
        String string;
        if (this.getIndividualCutoffAppliesTo() != INDIVIDUAL_SCORE_CUTOFF.NONE && (this.getIndividualScoreCutoffs() == null || this.getIndividualScoreCutoffs().size() < 1)) {
            throw new RuntimeException("attempt to use individual cuttoffs with having set them");
        }
        this.intitCounts();
        HashSet<String> hashSet = new HashSet<String>();
        String string2 = ForesterUtil.isReadableFile(this.getInputFile());
        if (!ForesterUtil.isEmpty(string2)) {
            throw new IOException(string2);
        }
        BufferedReader bufferedReader = new BufferedReader(new FileReader(this.getInputFile()));
        ArrayList<Protein> arrayList = new ArrayList<Protein>();
        Protein protein = null;
        int n = 0;
        long l = new Date().getTime();
        String string3 = "";
        int n2 = -1;
        while ((string = bufferedReader.readLine()) != null) {
            ++n;
            if (ForesterUtil.isEmpty(string) || string.startsWith("#")) continue;
            String[] stringArray = string.split("\\s+");
            String string4 = stringArray[0];
            String string5 = stringArray[1];
            int n3 = this.parseInt(stringArray[2], n, "tlen");
            String string6 = stringArray[3];
            String string7 = stringArray[4];
            int n4 = this.parseInt(stringArray[5], n, "qlen");
            double d = this.parseDouble(stringArray[6], n, "E-value");
            double d2 = this.parseDouble(stringArray[7], n, "score");
            int n5 = this.parseInt(stringArray[9], n, "count");
            int n6 = this.parseInt(stringArray[10], n, "total");
            double d3 = this.parseDouble(stringArray[11], n, "c-Evalue");
            double d4 = this.parseDouble(stringArray[12], n, "i-Evalue");
            double d5 = this.parseDouble(stringArray[13], n, "score");
            int n7 = this.parseInt(stringArray[15], n, "hmm from");
            int n8 = this.parseInt(stringArray[16], n, "hmm to");
            int n9 = this.parseInt(stringArray[17], n, "ali from");
            int n10 = this.parseInt(stringArray[18], n, "ali to");
            int n11 = this.parseInt(stringArray[19], n, "env from");
            int n12 = this.parseInt(stringArray[20], n, "env to");
            ++this._domains_encountered;
            if (!string6.equals(string3) || n4 != n2) {
                if (!this.isAllowProteinsWithSameName()) {
                    if (string6.equals(string3)) {
                        throw new IOException("more than one protein named [" + string6 + "]" + " lengths: " + n4 + ", " + n2);
                    }
                    if (hashSet.contains(string6)) {
                        throw new IOException("more than one protein named [" + string6 + "]");
                    }
                }
                string3 = string6;
                n2 = n4;
                hashSet.add(string6);
                if (protein != null && protein.getProteinDomains().size() > 0) {
                    this.addProtein(arrayList, protein);
                }
                if (this.getReturnType() == ReturnType.UNORDERED_PROTEIN_DOMAIN_COLLECTION_PER_PROTEIN) {
                    protein = new BasicProtein(string6, this.getSpecies(), n4);
                } else {
                    throw new IllegalArgumentException("unknown return type");
                }
            }
            boolean bl = false;
            if (this.getIndividualCutoffAppliesTo() != INDIVIDUAL_SCORE_CUTOFF.NONE) {
                if (this.getIndividualScoreCutoffs().containsKey(string4)) {
                    double d6 = this.getIndividualScoreCutoffs().get(string4);
                    if (this.getIndividualCutoffAppliesTo() != INDIVIDUAL_SCORE_CUTOFF.FULL_SEQUENCE) {
                        if (d2 < d6) {
                            bl = true;
                        }
                    } else if (this.getIndividualCutoffAppliesTo() != INDIVIDUAL_SCORE_CUTOFF.DOMAIN && d5 < d6) {
                        bl = true;
                    }
                } else {
                    throw new IOException("could not find a score cutoff value for domain id \"" + string4 + "\" [line " + n + "] in [" + this.getInputFile().getCanonicalPath() + "]");
                }
            }
            String string8 = string4.toUpperCase();
            if (bl) {
                ++this._domains_ignored_due_to_individual_score_cutoff;
                continue;
            }
            if (n9 == n10) continue;
            if (this.getEValueMaximum() != -1.0 && d > this.getEValueMaximum()) {
                ++this._domains_ignored_due_to_e_value;
                continue;
            }
            if (this.isIgnoreDufs() && string8.startsWith("DUF")) {
                ++this._domains_ignored_due_to_duf;
                continue;
            }
            if (this.isIgnoreVirusLikeIds() && (string8.contains(VIR) || string8.contains(PHAGE) || string8.contains(RETRO) || string8.contains(TRANSPOS) || string8.startsWith(RV) || string8.startsWith(GAG) || string8.startsWith(HCV) || string8.startsWith(HERPES) || string8.startsWith(BACULO))) {
                ForesterUtil.increaseCountingMap(this.getDomainsIgnoredDueToVirusLikeIdCountsMap(), string4);
                ++this._domains_ignored_due_to_virus_like_id;
                continue;
            }
            if (this.getFilterType() == FilterType.NEGATIVE_DOMAIN && this.getFilter().contains(new DomainId(string4))) {
                ++this._domains_ignored_due_to_negative_domain_filter;
                ForesterUtil.increaseCountingMap(this.getDomainsIgnoredDueToNegativeDomainFilterCountsMap(), string4);
                continue;
            }
            try {
                BasicDomain basicDomain = new BasicDomain(string4, n9, n10, (short)n5, (short)n6, d, d2, d4, d5);
                protein.addProteinDomain(basicDomain);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IOException("problem with domain parsing at line " + n + "[" + string + "]: " + illegalArgumentException.getMessage());
            }
            ++this._domains_stored;
        }
        if (protein != null && protein.getProteinDomains().size() > 0) {
            this.addProtein(arrayList, protein);
        }
        this.setProteinsEncountered(hashSet.size());
        this.setTime(new Date().getTime() - l);
        return arrayList;
    }

    private double parseDouble(String string, int n, String string2) throws IOException {
        double d = -1.0;
        try {
            d = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("could not parse \" +label + \" from \"" + string + "\" [line " + n + "] in [" + this.getInputFile().getCanonicalPath() + "]");
        }
        return d;
    }

    private int parseInt(String string, int n, String string2) throws IOException {
        int n2 = -1;
        try {
            n2 = Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("could not parse \"" + string2 + "\" from \"" + string + "\" [line " + n + "] in [" + this.getInputFile().getCanonicalPath() + "]");
        }
        return n2;
    }

    private void setDomainsEncountered(int n) {
        this._domains_encountered = n;
    }

    private void setDomainsIgnoredDueToDuf(int n) {
        this._domains_ignored_due_to_duf = n;
    }

    private void setDomainsIgnoredDueToEval(int n) {
        this._domains_ignored_due_to_e_value = n;
    }

    private void setDomainsIgnoredDueToIndividualScoreCutoff(int n) {
        this._domains_ignored_due_to_individual_score_cutoff = n;
    }

    private void setDomainsIgnoredDueToNegativeDomainFilterCountsMap(Map<String, Integer> map) {
        this._domains_ignored_due_to_negative_domain_filter_counts_map = map;
    }

    private void setDomainsIgnoredDueToNegativeFilter(int n) {
        this._domains_ignored_due_to_negative_domain_filter = n;
    }

    private void setDomainsIgnoredDueToOverlap(int n) {
        this._domains_ignored_due_to_overlap = n;
    }

    private void setDomainsIgnoredDueToVirusLikeId(int n) {
        this._domains_ignored_due_to_virus_like_id = n;
    }

    private void setDomainsIgnoredDueToVirusLikeIdCountsMap(Map<String, Integer> map) {
        this._domains_ignored_due_to_virus_like_id_counts_map = map;
    }

    private void setDomainsStored(int n) {
        this._domains_stored = n;
    }

    private void setDomainsStoredSet(SortedSet<DomainId> sortedSet) {
        this._domains_stored_set = sortedSet;
    }

    public void setEValueMaximum(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("attempt to set the maximum E-value to a negative value");
        }
        this._e_value_maximum = d;
    }

    public void setIgnoreDufs(boolean bl) {
        this._ignore_dufs = bl;
    }

    public void setIgnoreEngulfedDomains(boolean bl) {
        this._ignore_engulfed_domains = bl;
    }

    public void setIgnoreVirusLikeIds(boolean bl) {
        this._ignore_virus_like_ids = bl;
    }

    public void setIndividualScoreCutoffs(Map<String, Double> map) {
        this._individual_score_cutoffs = map;
    }

    public void setMaxAllowedOverlap(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Attempt to set max allowed overlap to less than zero.");
        }
        this._max_allowed_overlap = n;
    }

    private void setProteinsEncountered(int n) {
        this._proteins_encountered = n;
    }

    private void setProteinsIgnoredDueToFilter(int n) {
        this._proteins_ignored_due_to_filter = n;
    }

    private void setProteinsStored(int n) {
        this._proteins_stored = n;
    }

    public void setReturnType(ReturnType returnType) {
        this._return_type = returnType;
    }

    private void setTime(long l) {
        this._time = l;
    }

    public static enum ReturnType {
        UNORDERED_PROTEIN_DOMAIN_COLLECTION_PER_PROTEIN;

    }

    public static enum INDIVIDUAL_SCORE_CUTOFF {
        FULL_SEQUENCE,
        DOMAIN,
        NONE;

    }

    public static enum FilterType {
        NONE,
        POSITIVE_PROTEIN,
        NEGATIVE_PROTEIN,
        NEGATIVE_DOMAIN;

    }
}

