/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.parsers.nexus;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import org.forester.io.parsers.nexus.NexusFormatException;
import org.forester.io.parsers.util.ParserUtils;
import org.forester.io.parsers.util.PhylogenyParserException;
import org.forester.util.ForesterUtil;

public class NexusCharactersParser {
    private static final String charstatelabels = "CharStateLabels".toLowerCase();
    private Object _nexus_source;
    private String[] _char_state_labels;

    public String[] getCharStateLabels() {
        return this._char_state_labels;
    }

    private Object getNexusSource() {
        return this._nexus_source;
    }

    public void parse() throws IOException {
        String string;
        this.reset();
        BufferedReader bufferedReader = ParserUtils.createReader(this.getNexusSource());
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 1;
        while ((string = bufferedReader.readLine()) != null) {
            if ((string = string.trim()).length() <= 0 || string.startsWith("#") || string.startsWith(">")) continue;
            if (string.toLowerCase().startsWith(charstatelabels)) {
                bl = true;
            } else if (bl) {
                String string2 = string;
                if (string2.indexOf(32) > 0) {
                    String[] stringArray = string2.split("\\s+");
                    string2 = stringArray[1];
                    int n2 = -1;
                    try {
                        n2 = Integer.parseInt(stringArray[0]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new NexusFormatException("failed to parse character label number from: " + string);
                    }
                    if (n2 != n) {
                        throw new NexusFormatException("character label numbers are not in order, current line: " + string);
                    }
                }
                ++n;
                if (!ForesterUtil.isEmpty(string2 = string2.replaceAll("[\\s;\"',]+", ""))) {
                    if (arrayList.contains(string2)) {
                        throw new NexusFormatException("character label [" + string2 + "] is not unique");
                    }
                    arrayList.add(string2);
                }
            }
            if (!string.endsWith(";")) continue;
            bl = false;
        }
        this.setCharStateLabels(new String[arrayList.size()]);
        int n3 = 0;
        for (String string3 : arrayList) {
            this.getCharStateLabels()[n3++] = string3;
        }
    }

    private void reset() {
        this.setCharStateLabels(new String[0]);
    }

    private void setCharStateLabels(String[] stringArray) {
        this._char_state_labels = stringArray;
    }

    public void setSource(Object object) throws PhylogenyParserException, IOException {
        if (object == null) {
            throw new PhylogenyParserException(this.getClass() + ": attempt to parse null object.");
        }
        this._nexus_source = object;
    }
}

