/*
 * Decompiled with CFR 0.152.
 */
package org.forester.protein;

import org.forester.go.GoId;
import org.forester.protein.Domain;
import org.forester.protein.DomainId;
import org.forester.util.ForesterUtil;

public class BasicDomain
implements Domain {
    private final DomainId _id;
    private final int _from;
    private final int _to;
    private final short _number;
    private final short _total_count;
    private final double _per_sequence_evalue;
    private final double _per_sequence_score;
    private final double _per_domain_evalue;
    private final double _per_domain_score;

    public BasicDomain(String string) {
        if (ForesterUtil.isEmpty(string)) {
            throw new IllegalArgumentException("attempt to create protein domain with null or empty id");
        }
        this._id = new DomainId(string);
        this._from = -1;
        this._to = -1;
        this._number = (short)-1;
        this._total_count = (short)-1;
        this._per_sequence_evalue = -1.0;
        this._per_sequence_score = -1.0;
        this._per_domain_evalue = -1.0;
        this._per_domain_score = -1.0;
    }

    public BasicDomain(String string, int n, int n2, short s, short s2, double d, double d2) {
        this(string, n, n2, s, s2, d, d2, 0.0, 0.0);
    }

    public BasicDomain(String string, int n, int n2, short s, short s2, double d, double d2, double d3, double d4) {
        if (n >= n2 || n < 0) {
            throw new IllegalArgumentException("attempt to create protein domain from " + n + " to " + n2);
        }
        if (ForesterUtil.isEmpty(string)) {
            throw new IllegalArgumentException("attempt to create protein domain with null or empty id");
        }
        if (s > s2 || s < 0) {
            throw new IllegalArgumentException("attempt to create protein domain number " + s + " out of " + s2);
        }
        if (d < 0.0 || d3 < 0.0) {
            throw new IllegalArgumentException("attempt to create protein domain with negative E-value");
        }
        this._id = new DomainId(string);
        this._from = n;
        this._to = n2;
        this._number = s;
        this._total_count = s2;
        this._per_sequence_evalue = d;
        this._per_sequence_score = d2;
        this._per_domain_evalue = d3;
        this._per_domain_score = d4;
    }

    @Override
    public void addGoId(GoId goId) {
        this.getDomainId().getGoIds().add(goId);
    }

    @Override
    public int compareTo(Domain domain) {
        if (domain.getClass() != this.getClass()) {
            throw new IllegalArgumentException("attempt to compare [" + domain.getClass() + "] to " + "[" + this.getClass() + "]");
        }
        if (this == domain) {
            return 0;
        }
        return this.getDomainId().compareTo(domain.getDomainId());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            throw new IllegalArgumentException("attempt to check [" + this.getClass() + "] equality to null");
        }
        if (object.getClass() != this.getClass()) {
            throw new IllegalArgumentException("attempt to check [" + this.getClass() + "] equality to " + object + " [" + object.getClass() + "]");
        }
        return this.getDomainId().equals(((Domain)object).getDomainId());
    }

    @Override
    public DomainId getDomainId() {
        return this._id;
    }

    @Override
    public int getFrom() {
        return this._from;
    }

    @Override
    public GoId getGoId(int n) {
        return this.getDomainId().getGoIds().get(n);
    }

    @Override
    public short getNumber() {
        return this._number;
    }

    @Override
    public int getNumberOfGoIds() {
        return this.getDomainId().getGoIds().size();
    }

    @Override
    public double getPerDomainEvalue() {
        return this._per_domain_evalue;
    }

    @Override
    public double getPerDomainScore() {
        return this._per_domain_score;
    }

    @Override
    public double getPerSequenceEvalue() {
        return this._per_sequence_evalue;
    }

    @Override
    public double getPerSequenceScore() {
        return this._per_sequence_score;
    }

    @Override
    public int getTo() {
        return this._to;
    }

    @Override
    public short getTotalCount() {
        return this._total_count;
    }

    public int hashCode() {
        return this.getDomainId().getId().hashCode();
    }

    public String toString() {
        return this.toStringBuffer().toString();
    }

    public StringBuffer toStringBuffer() {
        return new StringBuffer(this.getDomainId().getId());
    }

    @Override
    public int getLength() {
        return 1 + this.getTo() - this.getFrom();
    }
}

