/*
 * Decompiled with CFR 0.152.
 */
package org.forester.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.forester.util.ThreadedStreamHandler;

public class SystemCommandExecutor {
    private final List<String> _command_information;
    private ThreadedStreamHandler _input_stream_handler;
    private ThreadedStreamHandler _error_stream_handler;
    private static final boolean DEBUG = false;

    public SystemCommandExecutor(List<String> list) {
        if (list == null || list.isEmpty()) {
            throw new IllegalArgumentException("command information is required");
        }
        SystemCommandExecutor.checkCmdFile(new File(list.get(0)));
        this._command_information = list;
    }

    public static boolean isExecuteableFile(File file) {
        if (!file.exists()) {
            return false;
        }
        if (file.isDirectory()) {
            return false;
        }
        return file.canExecute();
    }

    private static void checkCmdFile(File file) {
        if (!file.exists()) {
            throw new IllegalArgumentException("[" + file.getAbsolutePath() + "] does not exist");
        }
        if (file.isDirectory()) {
            throw new IllegalArgumentException("[" + file.getAbsolutePath() + "] is a directory");
        }
        if (!file.canExecute()) {
            throw new IllegalArgumentException("[" + file.getAbsolutePath() + "] is not executeable");
        }
    }

    public int executeCommand() throws IOException, InterruptedException {
        int n = -99;
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(this._command_information);
            Process process = processBuilder.start();
            OutputStream outputStream = process.getOutputStream();
            InputStream inputStream = process.getInputStream();
            InputStream inputStream2 = process.getErrorStream();
            this._input_stream_handler = new ThreadedStreamHandler(inputStream, outputStream);
            this._error_stream_handler = new ThreadedStreamHandler(inputStream2);
            this._input_stream_handler.start();
            this._error_stream_handler.start();
            n = process.waitFor();
            this._input_stream_handler.interrupt();
            this._error_stream_handler.interrupt();
            this._input_stream_handler.join();
            this._error_stream_handler.join();
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (InterruptedException interruptedException) {
            throw interruptedException;
        }
        return n;
    }

    public StringBuilder getStandardErrorFromCommand() {
        return this._error_stream_handler.getOutputBuffer();
    }

    public StringBuilder getStandardOutputFromCommand() {
        return this._input_stream_handler.getOutputBuffer();
    }
}

