/*
 * Decompiled with CFR 0.152.
 */
package org.forester.ws.uniprot;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.forester.phylogeny.data.Identifier;
import org.forester.util.ForesterUtil;
import org.forester.ws.uniprot.EbiDbEntry;
import org.forester.ws.uniprot.SequenceDatabaseEntry;
import org.forester.ws.uniprot.UniProtEntry;
import org.forester.ws.uniprot.UniProtTaxonomy;

public final class SequenceDbWsTools {
    private static final boolean ALLOW_TAXONOMY_CODE_HACKS = true;
    public static final String BASE_UNIPROT_URL = "http://www.uniprot.org/";
    public static final String BASE_EMBL_DB_URL = "http://www.ebi.ac.uk/Tools/dbfetch/dbfetch/";
    public static final String EMBL_DBS_EMBL = "embl";
    public static final String EMBL_DBS_REFSEQ_P = "refseqp";
    public static final String EMBL_DBS_REFSEQ_N = "refseqn";
    private static final String URL_ENC = "UTF-8";
    private static final Pattern UNIPROT_AC_PATTERN = Pattern.compile("(?:\\A|.*[^a-zA-Z0-9])([A-Z]\\d[A-Z0-9]{3}\\d)(?:[^a-zA-Z0-9]|\\Z)");
    private static final boolean DEBUG = false;

    private static String encode(String string) throws UnsupportedEncodingException {
        return URLEncoder.encode(string.trim(), URL_ENC);
    }

    public static String parseUniProtAccessor(String string) {
        Matcher matcher = UNIPROT_AC_PATTERN.matcher(string);
        if (matcher.lookingAt()) {
            return matcher.group(1);
        }
        return null;
    }

    public static List<UniProtTaxonomy> getTaxonomiesFromCommonName(String string, int n) throws IOException {
        List<String> list = SequenceDbWsTools.getTaxonomyStringFromCommonName(string, n);
        if (list.size() > 0) {
            return SequenceDbWsTools.parseUniProtTaxonomy(list);
        }
        return null;
    }

    public static List<UniProtTaxonomy> getTaxonomiesFromCommonNameStrict(String string, int n) throws IOException {
        List<UniProtTaxonomy> list = SequenceDbWsTools.getTaxonomiesFromCommonName(string, n);
        if (list != null && list.size() > 0) {
            ArrayList<UniProtTaxonomy> arrayList = new ArrayList<UniProtTaxonomy>();
            for (UniProtTaxonomy uniProtTaxonomy : list) {
                if (!uniProtTaxonomy.getCommonName().equalsIgnoreCase(string)) continue;
                arrayList.add(uniProtTaxonomy);
            }
            return arrayList;
        }
        return null;
    }

    public static List<UniProtTaxonomy> getTaxonomiesFromId(String string, int n) throws IOException {
        List<String> list = SequenceDbWsTools.getTaxonomyStringFromId(string, n);
        if (list.size() > 0) {
            return SequenceDbWsTools.parseUniProtTaxonomy(list);
        }
        return null;
    }

    public static List<UniProtTaxonomy> getTaxonomiesFromScientificName(String string, int n) throws IOException {
        if (string.equals("Drosophila")) {
            return SequenceDbWsTools.uniProtTaxonomyToList(UniProtTaxonomy.DROSOPHILA_GENUS);
        }
        if (string.equals("Xenopus")) {
            return SequenceDbWsTools.uniProtTaxonomyToList(UniProtTaxonomy.XENOPUS_GENUS);
        }
        List<String> list = SequenceDbWsTools.getTaxonomyStringFromScientificName(string, n);
        if (list.size() > 0) {
            return SequenceDbWsTools.parseUniProtTaxonomy(list);
        }
        return null;
    }

    public static List<UniProtTaxonomy> getTaxonomiesFromScientificNameStrict(String string, int n) throws IOException {
        List<UniProtTaxonomy> list = SequenceDbWsTools.getTaxonomiesFromScientificName(string, n);
        if (list != null && list.size() > 0) {
            ArrayList<UniProtTaxonomy> arrayList = new ArrayList<UniProtTaxonomy>();
            for (UniProtTaxonomy uniProtTaxonomy : list) {
                if (!uniProtTaxonomy.getScientificName().equalsIgnoreCase(string)) continue;
                arrayList.add(uniProtTaxonomy);
            }
            return arrayList;
        }
        return null;
    }

    public static List<UniProtTaxonomy> getTaxonomiesFromTaxonomyCode(String string, int n) throws IOException {
        String string2 = new String(string);
        List<Object> list = SequenceDbWsTools.resolveFakeTaxonomyCodes(n, string2);
        if (list != null) {
            return list;
        }
        list = SequenceDbWsTools.getTaxonomyStringFromTaxonomyCode(string2, n);
        if (list.size() > 0) {
            return SequenceDbWsTools.parseUniProtTaxonomy(list);
        }
        return null;
    }

    private static List<UniProtTaxonomy> resolveFakeTaxonomyCodes(int n, String string) throws IOException {
        if (string.equals("CAP")) {
            return SequenceDbWsTools.getTaxonomiesFromId("283909", n);
        }
        if (string.equals("FUGRU")) {
            return SequenceDbWsTools.getTaxonomiesFromId("31033", n);
        }
        if (string.equals("GIALA")) {
            return SequenceDbWsTools.getTaxonomiesFromId("5741", n);
        }
        if (string.equals("TRIVE")) {
            return SequenceDbWsTools.getTaxonomiesFromId("413071", n);
        }
        if (string.equals("CAPOWC")) {
            return SequenceDbWsTools.getTaxonomiesFromId("192875", n);
        }
        if (string.equals("SPHARC")) {
            return SequenceDbWsTools.getTaxonomiesFromId("667725", n);
        }
        if (string.equals("THETRA")) {
            return SequenceDbWsTools.getTaxonomiesFromId("529818", n);
        }
        if (string.equals("CHLVUL")) {
            return SequenceDbWsTools.getTaxonomiesFromId("574566", n);
        }
        if (string.equals("CITCLE")) {
            return SequenceDbWsTools.getTaxonomiesFromId("85681", n);
        }
        if (string.equals("MYCPOP")) {
            return SequenceDbWsTools.getTaxonomiesFromId("85929", n);
        }
        if (string.equals("AGABB")) {
            return SequenceDbWsTools.getTaxonomiesFromId("597362", n);
        }
        if (string.equals("BAUCOM")) {
            return SequenceDbWsTools.getTaxonomiesFromId("430998", n);
        }
        if (string.equals("DICSQU")) {
            return SequenceDbWsTools.getTaxonomiesFromId("114155", n);
        }
        if (string.equals("FOMPIN")) {
            return SequenceDbWsTools.getTaxonomiesFromId("40483", n);
        }
        if (string.equals("HYDMA")) {
            return SequenceDbWsTools.getTaxonomiesFromId("6085", n);
        }
        if (string.equals("MYCFI")) {
            return SequenceDbWsTools.getTaxonomiesFromId("83344", n);
        }
        if (string.equals("OIDMAI")) {
            return SequenceDbWsTools.getTaxonomiesFromId("78148", n);
        }
        if (string.equals("OSTRC")) {
            return SequenceDbWsTools.getTaxonomiesFromId("385169", n);
        }
        if (string.equals("POSPL")) {
            return SequenceDbWsTools.getTaxonomiesFromId("104341", n);
        }
        if (string.equals("SAICOM")) {
            return SequenceDbWsTools.getTaxonomiesFromId("5606", n);
        }
        if (string.equals("SERLA")) {
            return SequenceDbWsTools.getTaxonomiesFromId("85982", n);
        }
        if (string.equals("SPORO")) {
            return SequenceDbWsTools.getTaxonomiesFromId("40563", n);
        }
        if (string.equals("ACRALC")) {
            return SequenceDbWsTools.getTaxonomiesFromId("398408", n);
        }
        if (string.equals("THITER")) {
            return SequenceDbWsTools.getTaxonomiesFromId("35720", n);
        }
        if (string.equals("MYCTHE")) {
            return SequenceDbWsTools.getTaxonomiesFromId("78579", n);
        }
        if (string.equals("CONPUT")) {
            return SequenceDbWsTools.getTaxonomiesFromId("80637", n);
        }
        if (string.equals("WOLCOC")) {
            return SequenceDbWsTools.getTaxonomiesFromId("81056", n);
        }
        if (string.equals("CLAGRA")) {
            return SequenceDbWsTools.getTaxonomiesFromId("27339", n);
        }
        if (string.equals("XANPAR")) {
            return SequenceDbWsTools.getTaxonomiesFromId("107463", n);
        }
        if (string.equals("HYDPIN")) {
            return SequenceDbWsTools.getTaxonomiesFromId("388859", n);
        }
        if (string.equals("SERLAC")) {
            return SequenceDbWsTools.getTaxonomiesFromId("85982", n);
        }
        return null;
    }

    private static List<String> getTaxonomyStringFromCommonName(String string, int n) throws IOException {
        return SequenceDbWsTools.queryUniprot("taxonomy/?query=common%3a%22" + SequenceDbWsTools.encode(string) + "%22&format=tab", n);
    }

    private static List<String> getTaxonomyStringFromId(String string, int n) throws IOException {
        return SequenceDbWsTools.queryUniprot("taxonomy/?query=id%3a%22" + SequenceDbWsTools.encode(string) + "%22&format=tab", n);
    }

    private static List<String> getTaxonomyStringFromScientificName(String string, int n) throws IOException {
        return SequenceDbWsTools.queryUniprot("taxonomy/?query=scientific%3a%22" + SequenceDbWsTools.encode(string) + "%22&format=tab", n);
    }

    private static List<String> getTaxonomyStringFromTaxonomyCode(String string, int n) throws IOException {
        return SequenceDbWsTools.queryUniprot("taxonomy/?query=mnemonic%3a%22" + SequenceDbWsTools.encode(string) + "%22&format=tab", n);
    }

    private static List<UniProtTaxonomy> uniProtTaxonomyToList(UniProtTaxonomy uniProtTaxonomy) {
        ArrayList<UniProtTaxonomy> arrayList = new ArrayList<UniProtTaxonomy>();
        arrayList.add(uniProtTaxonomy);
        return arrayList;
    }

    private static List<UniProtTaxonomy> parseUniProtTaxonomy(List<String> list) throws IOException {
        ArrayList<UniProtTaxonomy> arrayList = new ArrayList<UniProtTaxonomy>();
        for (String string : list) {
            if (ForesterUtil.isEmpty(string)) continue;
            if (string.startsWith("Taxon")) {
                String[] stringArray = string.split("\t");
                if (stringArray[1].equalsIgnoreCase("Mnemonic") && stringArray[2].equalsIgnoreCase("Scientific name") && stringArray[3].equalsIgnoreCase("Common name") && stringArray[4].equalsIgnoreCase("Synonym") && stringArray[5].equalsIgnoreCase("Other Names") && stringArray[6].equalsIgnoreCase("Reviewed") && stringArray[7].equalsIgnoreCase("Rank") && stringArray[8].equalsIgnoreCase("Lineage")) continue;
                throw new IOException("Unreconized UniProt Taxonomy format: " + string);
            }
            if (string.split("\t").length <= 4) continue;
            arrayList.add(new UniProtTaxonomy(string));
        }
        return arrayList;
    }

    public static List<String> queryEmblDb(Identifier identifier, int n) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(BASE_EMBL_DB_URL);
        if (ForesterUtil.isEmpty(identifier.getProvider()) || identifier.getProvider().equalsIgnoreCase("ncbi")) {
            stringBuilder.append(EMBL_DBS_EMBL);
            stringBuilder.append('/');
        } else if (identifier.getProvider().equalsIgnoreCase("refseq")) {
            if (identifier.getValue().toUpperCase().indexOf(80) == 1) {
                stringBuilder.append(EMBL_DBS_REFSEQ_P);
                stringBuilder.append('/');
            } else {
                stringBuilder.append(EMBL_DBS_REFSEQ_N);
                stringBuilder.append('/');
            }
        }
        return SequenceDbWsTools.queryDb(identifier.getValue(), n, stringBuilder.toString());
    }

    public static List<String> queryUniprot(String string, int n) throws IOException {
        return SequenceDbWsTools.queryDb(string, n, BASE_UNIPROT_URL);
    }

    public static List<String> queryDb(String string, int n, String string2) throws IOException {
        String string3;
        if (ForesterUtil.isEmpty(string)) {
            throw new IllegalArgumentException("illegal attempt to use empty query ");
        }
        if (n < 1) {
            n = 1;
        }
        URL uRL = new URL(string2 + string);
        URLConnection uRLConnection = uRL.openConnection();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
        ArrayList<String> arrayList = new ArrayList<String>();
        while ((string3 = bufferedReader.readLine()) != null) {
            arrayList.add(string3);
            if (arrayList.size() <= n) continue;
        }
        bufferedReader.close();
        return arrayList;
    }

    public static SequenceDatabaseEntry obtainUniProtEntry(String string, int n) throws IOException {
        List<String> list = SequenceDbWsTools.queryUniprot("uniprot/" + string + ".txt", n);
        return UniProtEntry.createInstanceFromPlainText(list);
    }

    public static SequenceDatabaseEntry obtainRefSeqEntryFromEmbl(Identifier identifier, int n) throws IOException {
        List<String> list = SequenceDbWsTools.queryEmblDb(identifier, n);
        return EbiDbEntry.createInstanceFromPlainTextForRefSeq(list);
    }

    public static SequenceDatabaseEntry obtainEmblEntry(Identifier identifier, int n) throws IOException {
        List<String> list = SequenceDbWsTools.queryEmblDb(identifier, n);
        return EbiDbEntry.createInstanceFromPlainText(list);
    }

    public static enum Db {
        UNKNOWN,
        UNIPROT;

    }
}

