/*
 * Decompiled with CFR 0.152.
 */
package org.lorainelab.findjunctions;

import ch.qos.logback.classic.Level;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordIterator;
import net.sf.samtools.SAMValidationError;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.biojava.nbio.genome.parsers.twobit.TwoBitParser;
import org.lorainelab.findjunctions.BedLineBuilder;
import org.lorainelab.findjunctions.Intron;
import org.lorainelab.findjunctions.IntronCoordinateReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FindJunctions {
    private static final int DEFAULT_FLANK = 5;
    private static final Logger logger = LoggerFactory.getLogger(FindJunctions.class);

    private static CommandLine parseCommandLine(String[] args) {
        List<String> bam_names;
        HelpFormatter f;
        FindJunctions.setLoggingLevel(Level.INFO);
        CommandLine line = null;
        DefaultParser parser = new DefaultParser();
        Options options = new Options();
        options.addOption("u", "unique", false, "uniquely mapped reads only [optional]");
        options.addOption("h", "help", false, "print usage information");
        options.addOption("v", "verbose", false, "enables debug logging [optional]");
        Option option = Option.builder("b").longOpt("twobit").hasArg().argName("2BIT").required().desc("2bit file with genomic sequence [required]").build();
        options.addOption(option);
        option = Option.builder("o").longOpt("output").hasArg(true).desc("write output to file [optional]").numberOfArgs(1).optionalArg(true).argName("OUT").build();
        options.addOption(option);
        option = Option.builder("f").hasArg(true).longOpt("flank").argName("FLANK").numberOfArgs(1).type(Number.class).desc("read bases required to flank intron [default is 5]").build();
        options.addOption(option);
        String usage_string = "FindJunctions [options] FILE";
        try {
            int flank;
            line = parser.parse(options, args);
            if (line.hasOption("flank") && (flank = ((Number)line.getParsedOptionValue("flank")).intValue()) <= 0) {
                throw new Exception("flank must be positive integer");
            }
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
            f = new HelpFormatter();
            f.printHelp(usage_string, options);
            System.exit(1);
        }
        if (line.hasOption('h')) {
            HelpFormatter f2 = new HelpFormatter();
            f2.printHelp(usage_string, options);
            System.exit(0);
        }
        if (line.hasOption('v')) {
            FindJunctions.setLoggingLevel(Level.TRACE);
        }
        if ((bam_names = line.getArgList()).isEmpty()) {
            f = new HelpFormatter();
            f.printHelp(usage_string, options);
            System.exit(1);
        }
        return line;
    }

    public static void main(String[] args) throws ParseException, Exception {
        String[] bamNames;
        CommandLine line = FindJunctions.parseCommandLine(args);
        int flank = 5;
        if (line.hasOption("flank")) {
            flank = ((Number)line.getParsedOptionValue("flank")).intValue();
        }
        boolean unique = false;
        if (line.hasOption("unique")) {
            unique = true;
        }
        PrintStream printer = null;
        try {
            if (line.hasOption("output")) {
                String outfile_name = line.getOptionValue("output");
                printer = new PrintStream(new FileOutputStream(outfile_name));
            } else {
                printer = System.out;
            }
        }
        catch (FileNotFoundException ex) {
            String outfile_name = line.getOptionValue("output");
            System.err.printf("Could not write to file: %s.", outfile_name);
            System.exit(1);
        }
        HashMap<String, Intron> introns = new HashMap<String, Intron>();
        for (String bamName : bamNames = line.getArgs()) {
            try (SAMFileReader inputSam = new SAMFileReader(new File(bamName));){
                inputSam.setValidationStringency(SAMFileReader.ValidationStringency.SILENT);
                try (SAMRecordIterator iter = inputSam.iterator();){
                    while (iter.hasNext()) {
                        SAMRecord rec = (SAMRecord)iter.next();
                        if (!FindJunctions.checkValidSamRecord(rec) || rec.getReadUnmappedFlag()) continue;
                        if (unique) {
                            if (!FindJunctions.checkUniqueRead(rec)) continue;
                            FindJunctions.callIntronCoordinateReader(rec, flank, introns);
                            continue;
                        }
                        FindJunctions.callIntronCoordinateReader(rec, flank, introns);
                    }
                }
            }
        }
        String twoBitFileName = line.getOptionValue("b");
        File twoBitFileURI = new File(twoBitFileName);
        TwoBitParser sequenceReader = new TwoBitParser(twoBitFileURI);
        for (Map.Entry entry : introns.entrySet()) {
            String key = (String)entry.getKey();
            Intron intron = (Intron)entry.getValue();
            int start = intron.getStart();
            int end = intron.getEnd() - 2;
            String seqName = intron.getSeqName();
            sequenceReader.setCurrentSequence(seqName);
            String startBases = sequenceReader.loadFragment(start, 2);
            String endBases = sequenceReader.loadFragment(end, 2);
            logger.debug(startBases);
            FindJunctions.determineIntronStrand(startBases, endBases, intron);
            sequenceReader.close();
            intron.setDisplayName(key);
            String toPrint = BedLineBuilder.build(intron, flank);
            printer.println(toPrint);
        }
    }

    private static String makeKeyFromCoords(int[] coords, String seqName) {
        return String.format("%s:%d-%d", seqName, coords[0], coords[1]);
    }

    private static void setLoggingLevel(Level level) {
        ch.qos.logback.classic.Logger root = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger("ROOT");
        root.setLevel(level);
    }

    private static void callIntronCoordinateReader(SAMRecord rec, int flank, HashMap<String, Intron> introns) {
        ArrayList<int[]> coordsList = IntronCoordinateReader.getIntronCoords(rec, flank);
        String seqName = rec.getReferenceName();
        for (int[] coords : coordsList) {
            Intron intron;
            String key = FindJunctions.makeKeyFromCoords(coords, seqName);
            if (introns.containsKey(key)) {
                intron = introns.get(key);
                intron.incrementScore();
                continue;
            }
            intron = new Intron(coords, seqName, 1, rec.getCigarString(), rec.getAlignmentStart());
            introns.put(key, intron);
        }
    }

    private static boolean checkUniqueRead(SAMRecord rec) {
        List<SAMRecord.SAMTagAndValue> values = rec.getAttributes();
        boolean uniqueReadPresent = rec.getAttributes().stream().filter(s -> s.tag.equalsIgnoreCase("NH")).anyMatch(s -> s.value.equals(1));
        return uniqueReadPresent;
    }

    private static boolean checkValidSamRecord(SAMRecord rec) {
        List<SAMValidationError> errors = rec.isValid();
        return errors == null;
    }

    private static void determineIntronStrand(String startBases, String endBases, Intron intron) {
        if (startBases.equals("GT") && endBases.equals("AG")) {
            intron.setStrand(Intron.Strand.PLUS);
        } else if (startBases.equals("CT") && endBases.equals("GC")) {
            intron.setStrand(Intron.Strand.PLUS);
        } else if (startBases.equals("CT") || startBases.equals("GA") && endBases.equals("AC") || endBases.equals("TG")) {
            intron.setStrand(Intron.Strand.MINUS);
        } else if (startBases.equals("AT") || startBases.equals("GT") && endBases.equals("AC") || endBases.equals("AG")) {
            intron.setStrand(Intron.Strand.PLUS);
        } else if (startBases.equals("GT") || startBases.equals("CT") || startBases.equals("CA") || startBases.equals("GA") && (endBases.equals("AT") || endBases.equals("AC") || endBases.equals("TA") || endBases.equals("TG"))) {
            intron.setStrand(Intron.Strand.MINUS);
        } else {
            logger.info("Can't determine strand {}", (Object)intron);
            intron.setStrand(Intron.Strand.UNKNOWN);
        }
    }
}

