/*
 * Decompiled with CFR 0.152.
 */
package org.lorainelab.findjunctions;

import java.util.ArrayList;
import java.util.List;
import net.sf.samtools.CigarElement;
import net.sf.samtools.SAMRecord;

public class IntronCoordinateReader {
    protected static ArrayList<int[]> getIntronCoords(SAMRecord rec, int flank) {
        ArrayList<int[]> finalList = new ArrayList<int[]>();
        if (rec.getCigarString().contains("N")) {
            List<CigarElement> cigarList = rec.getCigar().getCigarElements();
            int coordinateStart = rec.getAlignmentStart() - 1;
            int intronStartOneBase = coordinateStart + cigarList.get(0).getLength();
            int intronEndOneBase = 0;
            finalList = IntronCoordinateReader.iterateThroughCigarList(cigarList, intronStartOneBase, intronEndOneBase, flank);
        }
        return finalList;
    }

    public static ArrayList<int[]> iterateThroughCigarList(List<CigarElement> cigarList, int intronStartOneBase, int intronEndOneBase, int flank) {
        ArrayList<int[]> finalList = new ArrayList<int[]>();
        String previousCigarElement = cigarList.get(0).getOperator().toString();
        for (int i = 1; i < cigarList.size() - 1; ++i) {
            String currentCigarElement = cigarList.get(i).getOperator().toString();
            int currentCigarElementLength = cigarList.get(i).getLength();
            if (!currentCigarElement.equals("N")) {
                if (previousCigarElement.equals("N")) {
                    intronStartOneBase = intronEndOneBase + currentCigarElementLength;
                } else if (!currentCigarElement.equals("I")) {
                    intronStartOneBase += currentCigarElementLength;
                }
            }
            if (currentCigarElement.equals("N") && (previousCigarElement.equals("M") || previousCigarElement.equals("I"))) {
                intronEndOneBase = intronStartOneBase + currentCigarElementLength;
                int previousCigarElementLength = cigarList.get(i - 1).getLength();
                int nextCigarElementLength = cigarList.get(i + 1).getLength();
                if (previousCigarElementLength >= flank && nextCigarElementLength >= flank) {
                    int[] intron = new int[]{intronStartOneBase, intronEndOneBase};
                    finalList.add(intron);
                }
            }
            previousCigarElement = currentCigarElement;
        }
        return finalList;
    }
}

